/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils.concurrent;

import com.alibaba.fluss.exception.FlussException;
import com.alibaba.fluss.testutils.common.FlussAssertions;
import com.alibaba.fluss.testutils.common.OneShotLatch;
import com.alibaba.fluss.testutils.common.TestExecutorExtension;
import com.alibaba.fluss.utils.concurrent.FutureUtils;
import com.alibaba.fluss.utils.concurrent.ManuallyTriggeredScheduledExecutor;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class FutureUtilsTest {
    @RegisterExtension
    static final TestExecutorExtension<ScheduledExecutorService> EXECUTOR_RESOURCE = new TestExecutorExtension(Executors::newSingleThreadScheduledExecutor);

    FutureUtilsTest() {
    }

    @Test
    void testComposeAfterwards() {
        CompletableFuture<Object> inputFuture = new CompletableFuture<Object>();
        OneShotLatch composeLatch = new OneShotLatch();
        CompletableFuture composeFuture = FutureUtils.composeAfterwards(inputFuture, () -> {
            composeLatch.trigger();
            return CompletableFuture.completedFuture(null);
        });
        Assertions.assertThat((boolean)composeLatch.isTriggered()).isFalse();
        Assertions.assertThat((CompletableFuture)composeFuture).isNotDone();
        inputFuture.complete(null);
        Assertions.assertThat((boolean)composeLatch.isTriggered()).isTrue();
        FlussAssertions.assertThatFuture((CompletableFuture)composeFuture).eventuallySucceeds();
    }

    @Test
    void testComposeAfterwardsFirstExceptional() {
        CompletableFuture inputFuture = new CompletableFuture();
        OneShotLatch composeLatch = new OneShotLatch();
        FlussException testException = new FlussException("Test exception");
        CompletableFuture composeFuture = FutureUtils.composeAfterwards(inputFuture, () -> {
            composeLatch.trigger();
            return CompletableFuture.completedFuture(null);
        });
        Assertions.assertThat((boolean)composeLatch.isTriggered()).isFalse();
        Assertions.assertThat((CompletableFuture)composeFuture).isNotDone();
        inputFuture.completeExceptionally((Throwable)testException);
        Assertions.assertThat((boolean)composeLatch.isTriggered()).isTrue();
        Assertions.assertThat((CompletableFuture)composeFuture).isDone();
        FlussAssertions.assertThatFuture((CompletableFuture)composeFuture).eventuallyFailsWith(ExecutionException.class).withCause((Throwable)testException);
    }

    @Test
    void testComposeAfterwardsSecondExceptional() {
        CompletableFuture<Object> inputFuture = new CompletableFuture<Object>();
        OneShotLatch composeLatch = new OneShotLatch();
        FlussException testException = new FlussException("Test exception");
        CompletableFuture composeFuture = FutureUtils.composeAfterwards(inputFuture, () -> {
            composeLatch.trigger();
            return FutureUtils.completedExceptionally((Throwable)testException);
        });
        Assertions.assertThat((boolean)composeLatch.isTriggered()).isFalse();
        Assertions.assertThat((CompletableFuture)composeFuture).isNotDone();
        inputFuture.complete(null);
        Assertions.assertThat((boolean)composeLatch.isTriggered()).isTrue();
        Assertions.assertThat((CompletableFuture)composeFuture).isDone();
        FlussAssertions.assertThatFuture((CompletableFuture)composeFuture).eventuallyFailsWith(ExecutionException.class).withCause((Throwable)testException);
    }

    @Test
    void testComposeAfterwardsBothExceptional() {
        CompletableFuture inputFuture = new CompletableFuture();
        FlussException testException1 = new FlussException("Test exception1");
        FlussException testException2 = new FlussException("Test exception2");
        OneShotLatch composeLatch = new OneShotLatch();
        CompletableFuture composeFuture = FutureUtils.composeAfterwards(inputFuture, () -> {
            composeLatch.trigger();
            return FutureUtils.completedExceptionally((Throwable)testException2);
        });
        Assertions.assertThat((boolean)composeLatch.isTriggered()).isFalse();
        Assertions.assertThat((CompletableFuture)composeFuture).isNotDone();
        inputFuture.completeExceptionally((Throwable)testException1);
        Assertions.assertThat((boolean)composeLatch.isTriggered()).isTrue();
        Assertions.assertThat((CompletableFuture)composeFuture).isDone();
        ((AbstractObjectAssert)FlussAssertions.assertThatFuture((CompletableFuture)composeFuture).eventuallyFailsWith(ExecutionException.class).extracting(Throwable::getCause).isEqualTo((Object)testException1)).satisfies(new ThrowingConsumer[]{cause -> {
            ObjectArrayAssert cfr_ignored_0 = (ObjectArrayAssert)Assertions.assertThat((Object[])cause.getSuppressed()).containsExactly((Object[])new Throwable[]{testException2});
        }});
    }

    @Test
    void testCompleteAll() {
        CompletableFuture<String> inputFuture1 = new CompletableFuture<String>();
        CompletableFuture<Integer> inputFuture2 = new CompletableFuture<Integer>();
        List<CompletableFuture> futuresToComplete = Arrays.asList(inputFuture1, inputFuture2);
        FutureUtils.ConjunctFuture completeFuture = FutureUtils.completeAll(futuresToComplete);
        Assertions.assertThat((CompletableFuture)completeFuture).isNotDone();
        Assertions.assertThat((int)completeFuture.getNumFuturesCompleted()).isZero();
        Assertions.assertThat((int)completeFuture.getNumFuturesTotal()).isEqualTo(futuresToComplete.size());
        inputFuture2.complete(42);
        Assertions.assertThat((CompletableFuture)completeFuture).isNotDone();
        Assertions.assertThat((int)completeFuture.getNumFuturesCompleted()).isOne();
        inputFuture1.complete("foobar");
        Assertions.assertThat((CompletableFuture)completeFuture).isDone();
        Assertions.assertThat((int)completeFuture.getNumFuturesCompleted()).isEqualTo(2);
        FlussAssertions.assertThatFuture((CompletableFuture)completeFuture).eventuallySucceeds();
    }

    @Test
    void testCompleteAllPartialExceptional() {
        CompletableFuture<String> inputFuture1 = new CompletableFuture<String>();
        CompletableFuture inputFuture2 = new CompletableFuture();
        List<CompletableFuture> futuresToComplete = Arrays.asList(inputFuture1, inputFuture2);
        FutureUtils.ConjunctFuture completeFuture = FutureUtils.completeAll(futuresToComplete);
        Assertions.assertThat((CompletableFuture)completeFuture).isNotDone();
        Assertions.assertThat((int)completeFuture.getNumFuturesCompleted()).isZero();
        Assertions.assertThat((int)completeFuture.getNumFuturesTotal()).isEqualTo(futuresToComplete.size());
        FlussException testException1 = new FlussException("Test exception 1");
        inputFuture2.completeExceptionally((Throwable)testException1);
        Assertions.assertThat((CompletableFuture)completeFuture).isNotDone();
        Assertions.assertThat((int)completeFuture.getNumFuturesCompleted()).isOne();
        inputFuture1.complete("foobar");
        Assertions.assertThat((CompletableFuture)completeFuture).isDone();
        Assertions.assertThat((int)completeFuture.getNumFuturesCompleted()).isEqualTo(2);
        FlussAssertions.assertThatFuture((CompletableFuture)completeFuture).eventuallyFailsWith(ExecutionException.class).withCause((Throwable)testException1);
    }

    @Test
    void testCompleteAllExceptional() {
        CompletableFuture inputFuture1 = new CompletableFuture();
        CompletableFuture inputFuture2 = new CompletableFuture();
        List<CompletableFuture> futuresToComplete = Arrays.asList(inputFuture1, inputFuture2);
        FutureUtils.ConjunctFuture completeFuture = FutureUtils.completeAll(futuresToComplete);
        Assertions.assertThat((CompletableFuture)completeFuture).isNotDone();
        Assertions.assertThat((int)completeFuture.getNumFuturesCompleted()).isZero();
        Assertions.assertThat((int)completeFuture.getNumFuturesTotal()).isEqualTo(futuresToComplete.size());
        FlussException testException1 = new FlussException("Test exception 1");
        inputFuture1.completeExceptionally((Throwable)testException1);
        Assertions.assertThat((CompletableFuture)completeFuture).isNotDone();
        Assertions.assertThat((int)completeFuture.getNumFuturesCompleted()).isOne();
        FlussException testException2 = new FlussException("Test exception 2");
        inputFuture2.completeExceptionally((Throwable)testException2);
        Assertions.assertThat((int)completeFuture.getNumFuturesCompleted()).isEqualTo(2);
        FlussAssertions.assertThatFuture((CompletableFuture)completeFuture).eventuallyFailsWith(ExecutionException.class).withCauseInstanceOf(FlussException.class).extracting(Throwable::getCause).satisfies(new ThrowingConsumer[]{e -> {
            Object[] actualSuppressedExceptions = e.getSuppressed();
            FlussException expectedSuppressedException = e.equals(testException1) ? testException2 : testException1;
            Assertions.assertThat((Object[])actualSuppressedExceptions).containsExactly((Object[])new Throwable[]{expectedSuppressedException});
        }});
    }

    @Test
    void testHandleUncaughtExceptionWithCompletedFuture() {
        CompletableFuture<String> future = CompletableFuture.completedFuture("foobar");
        TestingUncaughtExceptionHandler uncaughtExceptionHandler = new TestingUncaughtExceptionHandler();
        FutureUtils.handleUncaughtException(future, (Thread.UncaughtExceptionHandler)uncaughtExceptionHandler);
        Assertions.assertThat((boolean)uncaughtExceptionHandler.hasBeenCalled()).isFalse();
    }

    @Test
    void testHandleUncaughtExceptionWithNormalCompletion() {
        CompletableFuture<String> future = new CompletableFuture<String>();
        TestingUncaughtExceptionHandler uncaughtExceptionHandler = new TestingUncaughtExceptionHandler();
        FutureUtils.handleUncaughtException(future, (Thread.UncaughtExceptionHandler)uncaughtExceptionHandler);
        future.complete("barfoo");
        Assertions.assertThat((boolean)uncaughtExceptionHandler.hasBeenCalled()).isFalse();
    }

    @Test
    void testHandleUncaughtExceptionWithExceptionallyCompletedFuture() {
        CompletableFuture future = FutureUtils.completedExceptionally((Throwable)new FlussException("foobar"));
        TestingUncaughtExceptionHandler uncaughtExceptionHandler = new TestingUncaughtExceptionHandler();
        FutureUtils.handleUncaughtException((CompletableFuture)future, (Thread.UncaughtExceptionHandler)uncaughtExceptionHandler);
        Assertions.assertThat((boolean)uncaughtExceptionHandler.hasBeenCalled()).isTrue();
    }

    @Test
    void testHandleUncaughtExceptionWithExceptionallyCompletion() {
        CompletableFuture future = new CompletableFuture();
        TestingUncaughtExceptionHandler uncaughtExceptionHandler = new TestingUncaughtExceptionHandler();
        FutureUtils.handleUncaughtException(future, (Thread.UncaughtExceptionHandler)uncaughtExceptionHandler);
        Assertions.assertThat((boolean)uncaughtExceptionHandler.hasBeenCalled()).isFalse();
        future.completeExceptionally((Throwable)new FlussException("barfoo"));
        Assertions.assertThat((boolean)uncaughtExceptionHandler.hasBeenCalled()).isTrue();
    }

    @Test
    void testHandleUncaughtExceptionWithBuggyErrorHandlingCode() {
        Exception actualProductionCodeError = new Exception("Actual production code error that should be caught by the error handler.");
        RuntimeException errorHandlingException = new RuntimeException("Expected test error in error handling code.");
        Thread.UncaughtExceptionHandler buggyActualExceptionHandler = (thread, ignoredActualException) -> {
            throw errorHandlingException;
        };
        AtomicReference caughtErrorHandlingException = new AtomicReference();
        Thread.UncaughtExceptionHandler fallbackExceptionHandler = (thread, errorHandlingEx) -> caughtErrorHandlingException.set(errorHandlingEx);
        FutureUtils.handleUncaughtException((CompletableFuture)FutureUtils.completedExceptionally((Throwable)actualProductionCodeError), (Thread.UncaughtExceptionHandler)buggyActualExceptionHandler, (Thread.UncaughtExceptionHandler)fallbackExceptionHandler);
        Assertions.assertThat(caughtErrorHandlingException).hasValueSatisfying(actualError -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)actualError).isInstanceOf(IllegalStateException.class)).hasRootCause((Throwable)errorHandlingException).satisfies(new ThrowingConsumer[]{cause -> {
            ObjectArrayAssert cfr_ignored_0 = (ObjectArrayAssert)Assertions.assertThat((Object[])cause.getSuppressed()).containsExactly((Object[])new Throwable[]{actualProductionCodeError});
        }}));
    }

    @Test
    void testForwardAsync() {
        CompletableFuture<String> source = new CompletableFuture<String>();
        CompletableFuture target = new CompletableFuture();
        ManuallyTriggeredScheduledExecutor executor = new ManuallyTriggeredScheduledExecutor();
        FutureUtils.forwardAsync(source, target, (Executor)executor);
        String expectedValue = "foobar";
        source.complete("foobar");
        Assertions.assertThat(target).isNotDone();
        executor.triggerAll();
        FlussAssertions.assertThatFuture(target).eventuallySucceeds().isEqualTo((Object)"foobar");
    }

    @Test
    void testOrTimeout() {
        CompletableFuture future = new CompletableFuture();
        long timeout = 10L;
        String expectedErrorMessage = "testOrTimeout";
        FutureUtils.orTimeout(future, (long)10L, (TimeUnit)TimeUnit.MILLISECONDS, (String)"testOrTimeout");
        FlussAssertions.assertThatFuture(future).eventuallyFailsWith(ExecutionException.class).withCauseInstanceOf(TimeoutException.class).withMessageContaining("testOrTimeout");
    }

    private static class TestingUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private Throwable exception = null;

        private TestingUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.exception = e;
        }

        private boolean hasBeenCalled() {
            return this.exception != null;
        }
    }
}

