/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils.concurrent;

import com.alibaba.fluss.testutils.common.CommonTestUtils;
import com.alibaba.fluss.utils.concurrent.FlussScheduler;
import com.alibaba.fluss.utils.concurrent.Scheduler;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

final class SchedulerTest {
    private final AtomicInteger counter1 = new AtomicInteger(0);
    private final Scheduler scheduler = new FlussScheduler(1);

    SchedulerTest() {
    }

    @BeforeEach
    public void beforeEach() {
        this.scheduler.startup();
    }

    @AfterEach
    public void afterEach() throws InterruptedException {
        this.scheduler.shutdown();
    }

    @Test
    void testNonPeriodicTask() throws Exception {
        this.scheduler.scheduleOnce("test1", this.counter1::getAndIncrement);
        CommonTestUtils.retry((Duration)Duration.ofSeconds(30L), () -> Assertions.assertThat((int)this.counter1.get()).isEqualTo(1));
    }

    @Test
    void testNonPeriodicTaskWhenPeriodIsZero() throws Exception {
        this.scheduler.schedule("test1", this.counter1::getAndIncrement, 0L, 0L);
        CommonTestUtils.retry((Duration)Duration.ofSeconds(30L), () -> Assertions.assertThat((int)this.counter1.get()).isEqualTo(1));
    }

    @Test
    void testPeriodicTask() throws Exception {
        this.scheduler.schedule("test1", this.counter1::getAndIncrement, 0L, 5L);
        CommonTestUtils.retry((Duration)Duration.ofSeconds(30L), () -> Assertions.assertThat((int)this.counter1.get()).isGreaterThan(20));
    }
}

