/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils.json;

import com.alibaba.fluss.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import com.alibaba.fluss.utils.Preconditions;
import com.alibaba.fluss.utils.json.JsonDeserializer;
import com.alibaba.fluss.utils.json.JsonSerdeUtil;
import com.alibaba.fluss.utils.json.JsonSerializer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class JsonSerdeTestBase<T> {
    private final JsonSerializer<T> serializer;
    private final JsonDeserializer<T> deserializer;

    protected abstract T[] createObjects();

    protected abstract String[] expectedJsons();

    protected void assertEquals(T actual, T expected) {
        Assertions.assertThat(actual).isEqualTo(expected);
    }

    protected <SD extends JsonSerializer<T> & JsonDeserializer<T>> JsonSerdeTestBase(SD serde) {
        this.serializer = serde;
        this.deserializer = serde;
    }

    @Test
    void testJsonSerde() throws IOException {
        String[] expectedJsons;
        T[] testObjects = this.createObjects();
        Preconditions.checkArgument((testObjects.length == (expectedJsons = this.expectedJsons()).length ? 1 : 0) != 0, (String)"The length of createObjects() and expectedJsons() should be the same, but is %s and %s", (Object[])new Object[]{testObjects.length, expectedJsons.length});
        for (int i = 0; i < testObjects.length; ++i) {
            T value = testObjects[i];
            byte[] json = JsonSerdeUtil.writeValueAsBytes(value, this.serializer);
            JsonNode jsonNode = JsonSerdeUtil.OBJECT_MAPPER_INSTANCE.readTree(json);
            JsonSerdeTestBase.checkFieldNameLowerCase(jsonNode);
            Assertions.assertThat((String)new String(json, StandardCharsets.UTF_8)).isEqualTo(expectedJsons[i]);
            Object actual = JsonSerdeUtil.readValue((byte[])json, this.deserializer);
            this.assertEquals(actual, value);
        }
    }

    private static void checkFieldNameLowerCase(JsonNode jsonNode) {
        jsonNode.fields().forEachRemaining(field -> {
            String name = (String)field.getKey();
            ((AbstractStringAssert)Assertions.assertThat((String)name).as("json field name should be snake case, not camel case", new Object[0])).isEqualTo(JsonSerdeTestBase.camelToSnake(name));
            JsonSerdeTestBase.checkFieldNameLowerCase((JsonNode)field.getValue());
        });
    }

    public static String camelToSnake(String str) {
        String regex = "([a-z])([A-Z]+)";
        String replacement = "$1_$2";
        return str.replaceAll(regex, replacement).toLowerCase();
    }
}

