/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils.json;

import com.alibaba.fluss.metadata.Schema;
import com.alibaba.fluss.types.DataType;
import com.alibaba.fluss.types.DataTypes;
import com.alibaba.fluss.utils.json.JsonSerdeTestBase;
import com.alibaba.fluss.utils.json.SchemaJsonSerde;
import java.util.Arrays;
import java.util.Collections;

public class SchemaJsonSerdeTest
extends JsonSerdeTestBase<Schema> {
    static final Schema SCHEMA_0 = Schema.newBuilder().column("a", (DataType)DataTypes.INT()).withComment("a is first column").column("b", (DataType)DataTypes.STRING()).withComment("b is second column").column("c", (DataType)DataTypes.CHAR((int)10)).withComment("c is third column").primaryKey(new String[]{"a", "c"}).build();
    static final Schema SCHEMA_1 = Schema.newBuilder().fromColumns(Arrays.asList(new Schema.Column("a", (DataType)DataTypes.INT()), new Schema.Column("b", (DataType)DataTypes.STRING(), "b is second column"), new Schema.Column("c", (DataType)DataTypes.TIMESTAMP(), "c is third column"))).primaryKey(Collections.singletonList("a")).build();
    static final Schema SCHEMA_2 = Schema.newBuilder().fromSchema(SCHEMA_1).build();
    static final Schema SCHEMA_3 = Schema.newBuilder().column("a", (DataType)DataTypes.BIGINT()).withComment("a is first column").column("b", (DataType)DataTypes.STRING()).withComment("b is second column").column("c", (DataType)DataTypes.TIMESTAMP((int)6)).withComment("c is third column").build();
    static final String SCHEMA_JSON_0 = "{\"version\":1,\"columns\":[{\"name\":\"a\",\"data_type\":{\"type\":\"INTEGER\",\"nullable\":false},\"comment\":\"a is first column\"},{\"name\":\"b\",\"data_type\":{\"type\":\"STRING\"},\"comment\":\"b is second column\"},{\"name\":\"c\",\"data_type\":{\"type\":\"CHAR\",\"nullable\":false,\"length\":10},\"comment\":\"c is third column\"}],\"primary_key\":[\"a\",\"c\"]}";
    static final String SCHEMA_JSON_1 = "{\"version\":1,\"columns\":[{\"name\":\"a\",\"data_type\":{\"type\":\"INTEGER\",\"nullable\":false}},{\"name\":\"b\",\"data_type\":{\"type\":\"STRING\"},\"comment\":\"b is second column\"},{\"name\":\"c\",\"data_type\":{\"type\":\"TIMESTAMP_WITHOUT_TIME_ZONE\",\"precision\":6},\"comment\":\"c is third column\"}],\"primary_key\":[\"a\"]}";
    static final String SCHEMA_JSON_3 = "{\"version\":1,\"columns\":[{\"name\":\"a\",\"data_type\":{\"type\":\"BIGINT\"},\"comment\":\"a is first column\"},{\"name\":\"b\",\"data_type\":{\"type\":\"STRING\"},\"comment\":\"b is second column\"},{\"name\":\"c\",\"data_type\":{\"type\":\"TIMESTAMP_WITHOUT_TIME_ZONE\",\"precision\":6},\"comment\":\"c is third column\"}]}";

    SchemaJsonSerdeTest() {
        super(SchemaJsonSerde.INSTANCE);
    }

    protected Schema[] createObjects() {
        return new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    @Override
    protected String[] expectedJsons() {
        return new String[]{SCHEMA_JSON_0, SCHEMA_JSON_1, SCHEMA_JSON_1, SCHEMA_JSON_3};
    }
}

