/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils.log;

import com.alibaba.fluss.metadata.TableBucket;
import com.alibaba.fluss.utils.log.FairBucketStatusMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class FairBucketStatusMapTest {
    FairBucketStatusMapTest() {
    }

    @Test
    void testSet() {
        FairBucketStatusMap statuses = new FairBucketStatusMap();
        Map<TableBucket, String> map = this.createMap();
        statuses.set(map);
        LinkedHashMap<TableBucket, String> expected = new LinkedHashMap<TableBucket, String>();
        expected.put(new TableBucket(15000L, 2), "t1 2");
        expected.put(new TableBucket(15000L, 0), "t1 0");
        expected.put(new TableBucket(15001L, 2), "t2 2");
        expected.put(new TableBucket(15001L, 1), "t2 1");
        expected.put(new TableBucket(15002L, 2), "t3 2");
        expected.put(new TableBucket(15002L, 3), "t3 3");
        this.checkStatus((FairBucketStatusMap<String>)statuses, expected);
        statuses.set(new LinkedHashMap());
        this.checkStatus((FairBucketStatusMap<String>)statuses, new LinkedHashMap<TableBucket, String>());
    }

    @Test
    void testMoveToEnd() {
        FairBucketStatusMap statuses = new FairBucketStatusMap();
        Map<TableBucket, String> map = this.createMap();
        statuses.set(map);
        statuses.moveToEnd(new TableBucket(15002L, 2));
        LinkedHashMap<Object, String> expected = new LinkedHashMap<TableBucket, String>();
        expected.put(new TableBucket(15000L, 2), "t1 2");
        expected.put(new TableBucket(15000L, 0), "t1 0");
        expected.put(new TableBucket(15001L, 2), "t2 2");
        expected.put(new TableBucket(15001L, 1), "t2 1");
        expected.put(new TableBucket(15002L, 2), "t3 2");
        expected.put(new TableBucket(15002L, 3), "t3 3");
        this.checkStatus((FairBucketStatusMap<String>)statuses, expected);
        statuses.moveToEnd(new TableBucket(15000L, 2));
        expected = new LinkedHashMap();
        expected.put(new TableBucket(15000L, 0), "t1 0");
        expected.put(new TableBucket(15001L, 2), "t2 2");
        expected.put(new TableBucket(15001L, 1), "t2 1");
        expected.put(new TableBucket(15002L, 2), "t3 2");
        expected.put(new TableBucket(15002L, 3), "t3 3");
        expected.put(new TableBucket(15000L, 2), "t1 2");
        this.checkStatus((FairBucketStatusMap<String>)statuses, expected);
        statuses.moveToEnd(new TableBucket(15000L, 2));
        this.checkStatus((FairBucketStatusMap<String>)statuses, expected);
        statuses.moveToEnd(new TableBucket(15002L, 5));
        this.checkStatus((FairBucketStatusMap<String>)statuses, expected);
        statuses.moveToEnd(new TableBucket(15003L, 0));
        this.checkStatus((FairBucketStatusMap<String>)statuses, expected);
    }

    @Test
    void testUpdateAndMoveToEnd() {
        FairBucketStatusMap statuses = new FairBucketStatusMap();
        Map<TableBucket, String> map = this.createMap();
        statuses.set(map);
        statuses.updateAndMoveToEnd(new TableBucket(15000L, 0), (Object)"t1 0 updated");
        LinkedHashMap<Object, String> expected = new LinkedHashMap<TableBucket, String>();
        expected.put(new TableBucket(15000L, 2), "t1 2");
        expected.put(new TableBucket(15001L, 2), "t2 2");
        expected.put(new TableBucket(15001L, 1), "t2 1");
        expected.put(new TableBucket(15002L, 2), "t3 2");
        expected.put(new TableBucket(15002L, 3), "t3 3");
        expected.put(new TableBucket(15000L, 0), "t1 0 updated");
        this.checkStatus((FairBucketStatusMap<String>)statuses, expected);
        statuses.updateAndMoveToEnd(new TableBucket(15002L, 2), (Object)"t3 2 updated");
        expected = new LinkedHashMap();
        expected.put(new TableBucket(15000L, 2), "t1 2");
        expected.put(new TableBucket(15001L, 2), "t2 2");
        expected.put(new TableBucket(15001L, 1), "t2 1");
        expected.put(new TableBucket(15002L, 3), "t3 3");
        expected.put(new TableBucket(15000L, 0), "t1 0 updated");
        expected.put(new TableBucket(15002L, 2), "t3 2 updated");
        this.checkStatus((FairBucketStatusMap<String>)statuses, expected);
        statuses.updateAndMoveToEnd(new TableBucket(15002L, 5), (Object)"t3 5 new");
        expected = new LinkedHashMap();
        expected.put(new TableBucket(15000L, 2), "t1 2");
        expected.put(new TableBucket(15001L, 2), "t2 2");
        expected.put(new TableBucket(15001L, 1), "t2 1");
        expected.put(new TableBucket(15002L, 3), "t3 3");
        expected.put(new TableBucket(15000L, 0), "t1 0 updated");
        expected.put(new TableBucket(15002L, 2), "t3 2 updated");
        expected.put(new TableBucket(15002L, 5), "t3 5 new");
        this.checkStatus((FairBucketStatusMap<String>)statuses, expected);
        statuses.updateAndMoveToEnd(new TableBucket(15003L, 2), (Object)"t4 2 new");
        expected = new LinkedHashMap();
        expected.put(new TableBucket(15000L, 2), "t1 2");
        expected.put(new TableBucket(15001L, 2), "t2 2");
        expected.put(new TableBucket(15001L, 1), "t2 1");
        expected.put(new TableBucket(15002L, 3), "t3 3");
        expected.put(new TableBucket(15000L, 0), "t1 0 updated");
        expected.put(new TableBucket(15002L, 2), "t3 2 updated");
        expected.put(new TableBucket(15002L, 5), "t3 5 new");
        expected.put(new TableBucket(15003L, 2), "t4 2 new");
        this.checkStatus((FairBucketStatusMap<String>)statuses, expected);
    }

    @Test
    void testBucketValues() {
        FairBucketStatusMap statuses = new FairBucketStatusMap();
        Map<TableBucket, String> map = this.createMap();
        statuses.set(map);
        List<String> expected = Arrays.asList("t1 2", "t1 0", "t2 2", "t2 1", "t3 2", "t3 3");
        Assertions.assertThat((List)statuses.bucketStatusValues()).isEqualTo(expected);
    }

    @Test
    void testClear() {
        FairBucketStatusMap statuses = new FairBucketStatusMap();
        Map<TableBucket, String> map = this.createMap();
        statuses.set(map);
        statuses.clear();
        this.checkStatus((FairBucketStatusMap<String>)statuses, new LinkedHashMap<TableBucket, String>());
    }

    @Test
    void testRemove() {
        FairBucketStatusMap statuses = new FairBucketStatusMap();
        Map<TableBucket, String> map = this.createMap();
        statuses.set(map);
        statuses.remove(new TableBucket(15000L, 2));
        LinkedHashMap<Object, String> expected = new LinkedHashMap<TableBucket, String>();
        expected.put(new TableBucket(15000L, 0), "t1 0");
        expected.put(new TableBucket(15001L, 2), "t2 2");
        expected.put(new TableBucket(15001L, 1), "t2 1");
        expected.put(new TableBucket(15002L, 2), "t3 2");
        expected.put(new TableBucket(15002L, 3), "t3 3");
        this.checkStatus((FairBucketStatusMap<String>)statuses, expected);
        statuses.remove(new TableBucket(15001L, 1));
        expected = new LinkedHashMap();
        expected.put(new TableBucket(15000L, 0), "t1 0");
        expected.put(new TableBucket(15001L, 2), "t2 2");
        expected.put(new TableBucket(15002L, 2), "t3 2");
        expected.put(new TableBucket(15002L, 3), "t3 3");
        this.checkStatus((FairBucketStatusMap<String>)statuses, expected);
    }

    private Map<TableBucket, String> createMap() {
        LinkedHashMap<TableBucket, String> map = new LinkedHashMap<TableBucket, String>();
        map.put(new TableBucket(15000L, 2), "t1 2");
        map.put(new TableBucket(15001L, 2), "t2 2");
        map.put(new TableBucket(15001L, 1), "t2 1");
        map.put(new TableBucket(15002L, 2), "t3 2");
        map.put(new TableBucket(15000L, 0), "t1 0");
        map.put(new TableBucket(15002L, 3), "t3 3");
        return map;
    }

    private void checkStatus(FairBucketStatusMap<String> statuses, Map<TableBucket, String> map) {
        Assertions.assertThat((Collection)statuses.bucketSet()).isEqualTo(map.keySet());
        Assertions.assertThat((int)statuses.size()).isEqualTo(map.size());
        Assertions.assertThat((Map)statuses.bucketStatusMap()).isEqualTo(map);
    }
}

