/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.protogen.maven.plugin;

import com.alibaba.fluss.protogen.generator.generator.ProtoCodeGenerator;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class ProtoGenMojo
extends AbstractMojo {
    @Parameter(property="classPrefix", defaultValue="", required=false)
    private String classPrefix;
    @Parameter(property="singleOuterClass", defaultValue="false", required=false)
    private boolean singleOuterClass;
    @Parameter(property="sources", required=false)
    private List<File> sources;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="generated-sources/protobuf/java", required=false)
    private String targetSourcesSubDir;
    @Parameter(defaultValue="generated-test-sources/protobuf/java", required=false)
    private String targetTestSourcesSubDir;

    private void generate(List<File> protoFiles, File outputDirectory) throws MojoExecutionException {
        try {
            ProtoCodeGenerator.generate(protoFiles, (File)outputDirectory, (String)this.classPrefix, (boolean)this.singleOuterClass);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Failed to generate protogen code for " + protoFiles + ": " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("Failed to generate protogen code for " + protoFiles, e);
        }
    }

    public void execute() throws MojoExecutionException {
        File baseDir = this.project.getBasedir();
        File targetDir = new File(this.project.getBuild().getDirectory());
        if (this.sources == null || this.sources.isEmpty()) {
            File[] testFilesArray;
            File[] mainFilesArray = new File(baseDir, "src/main/proto").listFiles((dir, name) -> name.endsWith(".proto"));
            if (mainFilesArray != null && mainFilesArray.length > 0) {
                List<File> mainFiles = Arrays.asList(mainFilesArray);
                File generatedSourcesDir = new File(targetDir, this.targetSourcesSubDir);
                this.generate(mainFiles, new File(targetDir, this.targetSourcesSubDir));
                this.project.addCompileSourceRoot(generatedSourcesDir.toString());
            }
            if ((testFilesArray = new File(baseDir, "src/test/proto").listFiles((dir, name) -> name.endsWith(".proto"))) != null && testFilesArray.length > 0) {
                List<File> testFiles = Arrays.asList(testFilesArray);
                File generatedTestSourcesDir = new File(targetDir, this.targetTestSourcesSubDir);
                this.generate(testFiles, generatedTestSourcesDir);
                this.project.addTestCompileSourceRoot(generatedTestSourcesDir.toString());
            }
        } else {
            File generatedSourcesDir = new File(targetDir, this.targetSourcesSubDir);
            this.generate(this.sources, generatedSourcesDir);
            this.project.addCompileSourceRoot(generatedSourcesDir.toString());
        }
    }
}

