/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.shaded.jackson2.com.fasterxml.jackson.datatype.jdk8;

import com.alibaba.fluss.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import com.alibaba.fluss.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import com.alibaba.fluss.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.alibaba.fluss.shaded.jackson2.com.fasterxml.jackson.datatype.jdk8.WrappedIOException;
import java.io.IOException;
import java.util.stream.LongStream;

public class LongStreamSerializer
extends StdSerializer<LongStream> {
    private static final long serialVersionUID = 1L;
    public static final LongStreamSerializer INSTANCE = new LongStreamSerializer();

    private LongStreamSerializer() {
        super(LongStream.class);
    }

    @Override
    public void serialize(LongStream stream, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        try (LongStream ls = stream;){
            jgen.writeStartArray();
            ls.forEachOrdered(value -> {
                try {
                    jgen.writeNumber(value);
                }
                catch (IOException e) {
                    throw new WrappedIOException(e);
                }
            });
            jgen.writeEndArray();
        }
        catch (WrappedIOException e) {
            throw e.getCause();
        }
    }
}

