/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.shaded.netty4.io.netty.handler.codec.dns;

import com.alibaba.fluss.shaded.netty4.io.netty.buffer.ByteBuf;
import com.alibaba.fluss.shaded.netty4.io.netty.channel.AddressedEnvelope;
import com.alibaba.fluss.shaded.netty4.io.netty.channel.ChannelHandler;
import com.alibaba.fluss.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import com.alibaba.fluss.shaded.netty4.io.netty.channel.socket.DatagramPacket;
import com.alibaba.fluss.shaded.netty4.io.netty.handler.codec.MessageToMessageEncoder;
import com.alibaba.fluss.shaded.netty4.io.netty.handler.codec.dns.DnsMessageUtil;
import com.alibaba.fluss.shaded.netty4.io.netty.handler.codec.dns.DnsRecordEncoder;
import com.alibaba.fluss.shaded.netty4.io.netty.handler.codec.dns.DnsResponse;
import com.alibaba.fluss.shaded.netty4.io.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;
import java.util.List;

@ChannelHandler.Sharable
public class DatagramDnsResponseEncoder
extends MessageToMessageEncoder<AddressedEnvelope<DnsResponse, InetSocketAddress>> {
    private final DnsRecordEncoder recordEncoder;

    public DatagramDnsResponseEncoder() {
        this(DnsRecordEncoder.DEFAULT);
    }

    public DatagramDnsResponseEncoder(DnsRecordEncoder recordEncoder) {
        this.recordEncoder = ObjectUtil.checkNotNull(recordEncoder, "recordEncoder");
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, AddressedEnvelope<DnsResponse, InetSocketAddress> in, List<Object> out) throws Exception {
        InetSocketAddress recipient = in.recipient();
        DnsResponse response = in.content();
        ByteBuf buf = this.allocateBuffer(ctx, in);
        DnsMessageUtil.encodeDnsResponse(this.recordEncoder, response, buf);
        out.add(new DatagramPacket(buf, recipient, null));
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, AddressedEnvelope<DnsResponse, InetSocketAddress> msg) throws Exception {
        return ctx.alloc().ioBuffer(1024);
    }
}

