/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.shaded.netty4.io.netty.handler.codec.dns;

import com.alibaba.fluss.shaded.netty4.io.netty.buffer.ByteBuf;
import com.alibaba.fluss.shaded.netty4.io.netty.channel.ChannelHandler;
import com.alibaba.fluss.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import com.alibaba.fluss.shaded.netty4.io.netty.handler.codec.MessageToMessageEncoder;
import com.alibaba.fluss.shaded.netty4.io.netty.handler.codec.dns.DnsMessageUtil;
import com.alibaba.fluss.shaded.netty4.io.netty.handler.codec.dns.DnsRecordEncoder;
import com.alibaba.fluss.shaded.netty4.io.netty.handler.codec.dns.DnsResponse;
import com.alibaba.fluss.shaded.netty4.io.netty.util.internal.ObjectUtil;
import java.util.List;

@ChannelHandler.Sharable
public final class TcpDnsResponseEncoder
extends MessageToMessageEncoder<DnsResponse> {
    private final DnsRecordEncoder encoder;

    public TcpDnsResponseEncoder() {
        this(DnsRecordEncoder.DEFAULT);
    }

    public TcpDnsResponseEncoder(DnsRecordEncoder encoder) {
        this.encoder = ObjectUtil.checkNotNull(encoder, "encoder");
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, DnsResponse response, List<Object> out) throws Exception {
        ByteBuf buf = ctx.alloc().ioBuffer(1024);
        buf.writerIndex(buf.writerIndex() + 2);
        DnsMessageUtil.encodeDnsResponse(this.encoder, response, buf);
        buf.setShort(0, buf.readableBytes() - 2);
        out.add(buf);
    }
}

