/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.api;

import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.WatchedEvent;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.Watcher;

/**
 * A version of {@link Watcher} that can throw an exception
 */
public interface CuratorWatcher
{
    /**
     * Same as {@link Watcher#process(WatchedEvent)}. If an exception
     * is thrown, Curator will log it
     *
     * @param event the event
     * @throws Exception any exceptions to log
     */
    public void process(WatchedEvent event) throws Exception;
}
