/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership. The ASF
 * licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.KeeperException;

/**
 * getAllChildrenNumber command for CLI
 */
public class GetAllChildrenNumberCommand extends CliCommand {

    private static Options options = new Options();
    private String[] args;

    public GetAllChildrenNumberCommand() {
        super("getAllChildrenNumber", "path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        DefaultParser parser = new DefaultParser();
        CommandLine cl;
        try {
            cl = parser.parse(options, cmdArgs);
        } catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        args = cl.getArgs();

        return this;
    }

    @Override
    public boolean exec() throws CliException {
        if (args.length < 2) {
            throw new MalformedCommandException(getUsageStr());
        }

        try {
            String path = args[1];
            int allChildrenNumber = zk.getAllChildrenNumber(path);

            out.println(allChildrenNumber);
        } catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        } catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }

        return false;
    }

}
