/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.imps;

import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.api.CuratorWatcher;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.imps.NamespaceWatchedEvent;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.shaded.com.google.common.base.Objects;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.shaded.com.google.common.base.Preconditions;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.utils.ThreadUtils;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.WatchedEvent;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.Watcher;
import java.io.Closeable;

class NamespaceWatcher
implements Watcher,
Closeable {
    private volatile CuratorFrameworkImpl client;
    private volatile Watcher actualWatcher;
    private final String unfixedPath;
    private volatile CuratorWatcher curatorWatcher;

    NamespaceWatcher(CuratorFrameworkImpl client, Watcher actualWatcher, String unfixedPath) {
        this.client = client;
        this.actualWatcher = actualWatcher;
        this.unfixedPath = Preconditions.checkNotNull(unfixedPath, "unfixedPath cannot be null");
        this.curatorWatcher = null;
    }

    NamespaceWatcher(CuratorFrameworkImpl client, CuratorWatcher curatorWatcher, String unfixedPath) {
        this.client = client;
        this.actualWatcher = null;
        this.curatorWatcher = curatorWatcher;
        this.unfixedPath = Preconditions.checkNotNull(unfixedPath, "unfixedPath cannot be null");
    }

    String getUnfixedPath() {
        return this.unfixedPath;
    }

    @Override
    public void close() {
        this.client = null;
        this.actualWatcher = null;
        this.curatorWatcher = null;
    }

    @Override
    public void process(WatchedEvent event) {
        if (this.client != null) {
            if (event.getType() != Watcher.Event.EventType.None && this.client.getWatcherRemovalManager() != null) {
                this.client.getWatcherRemovalManager().noteTriggeredWatcher(this);
            }
            if (this.actualWatcher != null) {
                this.actualWatcher.process(new NamespaceWatchedEvent(this.client, event));
            } else if (this.curatorWatcher != null) {
                try {
                    this.curatorWatcher.process(new NamespaceWatchedEvent(this.client, event));
                }
                catch (Exception e) {
                    ThreadUtils.checkInterrupted(e);
                    this.client.logError("Watcher exception", e);
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() == o.getClass()) {
            NamespaceWatcher watcher = (NamespaceWatcher)o;
            return Objects.equal(this.unfixedPath, watcher.getUnfixedPath()) && Objects.equal(this.actualWatcher, watcher.actualWatcher) && Objects.equal(this.curatorWatcher, watcher.curatorWatcher);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.actualWatcher, this.unfixedPath, this.curatorWatcher);
    }
}

