/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.cache;

import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.cache.CompatibleCuratorCacheBridge;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.cache.CuratorCache;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.cache.CuratorCacheBridge;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.cache.CuratorCacheBridgeBuilder;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.cache.CuratorCacheImpl;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.cache.CuratorCacheStorage;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.utils.Compatibility;
import java.util.concurrent.ExecutorService;
import org.slf4j.LoggerFactory;

class CuratorCacheBridgeBuilderImpl
implements CuratorCacheBridgeBuilder {
    private final CuratorFramework client;
    private final String path;
    private CuratorCache.Options[] options;
    private boolean cacheData = true;
    private ExecutorService executorService = null;
    private final boolean forceTreeCache = Boolean.getBoolean("curator-cache-bridge-force-tree-cache");

    CuratorCacheBridgeBuilderImpl(CuratorFramework client, String path) {
        this.client = client;
        this.path = path;
    }

    @Override
    public CuratorCacheBridgeBuilder withOptions(CuratorCache.Options ... options) {
        this.options = options;
        return this;
    }

    @Override
    public CuratorCacheBridgeBuilder withDataNotCached() {
        this.cacheData = false;
        return this;
    }

    @Override
    public CuratorCacheBridgeBuilder withExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    @Override
    public CuratorCacheBridge build() {
        if (!this.forceTreeCache && Compatibility.hasPersistentWatchers()) {
            if (this.executorService != null) {
                LoggerFactory.getLogger(this.getClass()).warn("CuratorCache does not support custom ExecutorService");
            }
            CuratorCacheStorage storage = this.cacheData ? CuratorCacheStorage.standard() : CuratorCacheStorage.dataNotCached();
            return new CuratorCacheImpl(this.client, storage, this.path, this.options, null);
        }
        return new CompatibleCuratorCacheBridge(this.client, this.path, this.options, this.executorService, this.cacheData);
    }
}

