/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.cache;

import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.api.BackgroundCallback;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.api.CuratorEvent;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.api.ErrorListenerPathable;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.api.GetDataWatchBackgroundStatable;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.listen.Listenable;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.listen.StandardListenerManager;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.cache.ChildData;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.cache.CuratorCache;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.cache.CuratorCacheBridge;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.cache.CuratorCacheStorage;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.watch.PersistentWatcher;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.shaded.com.google.common.base.Preconditions;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.shaded.com.google.common.collect.Sets;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.utils.ThreadUtils;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.utils.ZKPaths;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.KeeperException;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.WatchedEvent;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.data.Stat;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CuratorCacheImpl
implements CuratorCache,
CuratorCacheBridge {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final PersistentWatcher persistentWatcher;
    private final CuratorFramework client;
    private final CuratorCacheStorage storage;
    private final String path;
    private final boolean recursive;
    private final boolean compressedData;
    private final boolean clearOnClose;
    private final StandardListenerManager<CuratorCacheListener> listenerManager = StandardListenerManager.standard();
    private final Consumer<Exception> exceptionHandler;
    private final Phaser outstandingOps = new Phaser(){

        @Override
        protected boolean onAdvance(int phase, int registeredParties) {
            CuratorCacheImpl.this.callListeners(CuratorCacheListener::initialized);
            return true;
        }
    };

    CuratorCacheImpl(CuratorFramework client, CuratorCacheStorage storage, String path, CuratorCache.Options[] optionsArg, Consumer<Exception> exceptionHandler) {
        Set options = optionsArg != null ? Sets.newHashSet(optionsArg) : Collections.emptySet();
        this.client = client;
        this.storage = storage != null ? storage : CuratorCacheStorage.standard();
        this.path = path;
        this.recursive = !options.contains((Object)CuratorCache.Options.SINGLE_NODE_CACHE);
        this.compressedData = options.contains((Object)CuratorCache.Options.COMPRESSED_DATA);
        this.clearOnClose = !options.contains((Object)CuratorCache.Options.DO_NOT_CLEAR_ON_CLOSE);
        this.persistentWatcher = new PersistentWatcher(client, path, this.recursive);
        this.persistentWatcher.getListenable().addListener(this::processEvent);
        this.persistentWatcher.getResetListenable().addListener(this::rebuild);
        this.exceptionHandler = exceptionHandler != null ? exceptionHandler : e -> this.log.error("CuratorCache error", (Throwable)e);
    }

    @Override
    public void start() {
        Preconditions.checkState(this.state.compareAndSet(State.LATENT, State.STARTED), "Already started");
        this.persistentWatcher.start();
    }

    @Override
    public void close() {
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            this.persistentWatcher.close();
            if (this.clearOnClose) {
                this.storage.clear();
            }
        }
    }

    @Override
    public boolean isCuratorCache() {
        return true;
    }

    @Override
    public Listenable<CuratorCacheListener> listenable() {
        return this.listenerManager;
    }

    @Override
    public Optional<ChildData> get(String path) {
        return this.storage.get(path);
    }

    @Override
    public int size() {
        return this.storage.size();
    }

    @Override
    public Stream<ChildData> stream() {
        return this.storage.stream();
    }

    @VisibleForTesting
    CuratorCacheStorage storage() {
        return this.storage;
    }

    private void rebuild() {
        if (this.state.get() != State.STARTED) {
            return;
        }
        this.nodeChanged(this.path);
        this.storage.stream().map(ChildData::getPath).filter(p -> !p.equals(this.path)).forEach(this::nodeChanged);
    }

    private void processEvent(WatchedEvent event) {
        if (this.state.get() != State.STARTED) {
            return;
        }
        switch (event.getType()) {
            case NodeDataChanged: 
            case NodeCreated: {
                this.nodeChanged(event.getPath());
                break;
            }
            case NodeDeleted: {
                this.removeStorage(event.getPath());
            }
        }
    }

    private void checkChildrenChanged(String fromPath, Stat oldStat, Stat newStat) {
        if (this.state.get() != State.STARTED || !this.recursive) {
            return;
        }
        if (oldStat != null && oldStat.getCversion() == newStat.getCversion()) {
            return;
        }
        try {
            BackgroundCallback callback = (__, event) -> {
                if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                    event.getChildren().forEach(child -> this.nodeChanged(ZKPaths.makePath(fromPath, child)));
                } else if (event.getResultCode() == KeeperException.Code.NONODE.intValue()) {
                    this.removeStorage(event.getPath());
                } else {
                    this.handleException(event);
                }
                this.outstandingOps.arriveAndDeregister();
            };
            this.outstandingOps.register();
            ((ErrorListenerPathable)this.client.getChildren().inBackground(callback)).forPath(fromPath);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void nodeChanged(String fromPath) {
        if (this.state.get() != State.STARTED) {
            return;
        }
        try {
            BackgroundCallback callback = (__, event) -> {
                if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                    Optional<ChildData> childData = this.putStorage(new ChildData(event.getPath(), event.getStat(), event.getData()));
                    this.checkChildrenChanged(event.getPath(), childData.map(ChildData::getStat).orElse(null), event.getStat());
                } else if (event.getResultCode() == KeeperException.Code.NONODE.intValue()) {
                    this.removeStorage(event.getPath());
                } else {
                    this.handleException(event);
                }
                this.outstandingOps.arriveAndDeregister();
            };
            this.outstandingOps.register();
            if (this.compressedData) {
                ((ErrorListenerPathable)((GetDataWatchBackgroundStatable)this.client.getData().decompressed()).inBackground(callback)).forPath(fromPath);
            } else {
                ((ErrorListenerPathable)this.client.getData().inBackground(callback)).forPath(fromPath);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private Optional<ChildData> putStorage(ChildData data) {
        Optional<ChildData> previousData = this.storage.put(data);
        if (previousData.isPresent()) {
            if (previousData.get().getStat().getVersion() != data.getStat().getVersion()) {
                this.callListeners(l -> l.event(CuratorCacheListener.Type.NODE_CHANGED, (ChildData)previousData.get(), data));
            }
        } else {
            this.callListeners(l -> l.event(CuratorCacheListener.Type.NODE_CREATED, null, data));
        }
        return previousData;
    }

    private void removeStorage(String path) {
        this.storage.remove(path).ifPresent(previousData -> this.callListeners(l -> l.event(CuratorCacheListener.Type.NODE_DELETED, (ChildData)previousData, null)));
    }

    private void callListeners(Consumer<CuratorCacheListener> proc) {
        if (this.state.get() == State.STARTED) {
            this.client.runSafe(() -> this.listenerManager.forEach(proc));
        }
    }

    private void handleException(CuratorEvent event) {
        this.handleException(KeeperException.create(KeeperException.Code.get(event.getResultCode())));
    }

    private void handleException(Exception e) {
        ThreadUtils.checkInterrupted(e);
        this.exceptionHandler.accept(e);
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

