/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.locks;

import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.locks.InterProcessLock;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.locks.LockInternals;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.locks.LockInternalsDriver;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.locks.Revocable;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.locks.RevocationListener;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.locks.RevocationSpec;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.locks.StandardLockInternalsDriver;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.shaded.com.google.common.collect.Maps;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.shaded.com.google.common.util.concurrent.MoreExecutors;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.utils.PathUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class InterProcessMutex
implements InterProcessLock,
Revocable<InterProcessMutex> {
    private final LockInternals internals;
    private final String basePath;
    private final ConcurrentMap<Thread, LockData> threadData = Maps.newConcurrentMap();
    private static final String LOCK_NAME = "lock-";

    public InterProcessMutex(CuratorFramework client, String path) {
        this(client, path, new StandardLockInternalsDriver());
    }

    public InterProcessMutex(CuratorFramework client, String path, LockInternalsDriver driver) {
        this(client, path, LOCK_NAME, 1, driver);
    }

    @Override
    public void acquire() throws Exception {
        if (!this.internalLock(-1L, null)) {
            throw new IOException("Lost connection while trying to acquire lock: " + this.basePath);
        }
    }

    @Override
    public boolean acquire(long time, TimeUnit unit) throws Exception {
        return this.internalLock(time, unit);
    }

    @Override
    public boolean isAcquiredInThisProcess() {
        return this.threadData.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws Exception {
        Thread currentThread = Thread.currentThread();
        LockData lockData = (LockData)this.threadData.get(currentThread);
        if (lockData == null) {
            throw new IllegalMonitorStateException("You do not own the lock: " + this.basePath);
        }
        int newLockCount = lockData.lockCount.decrementAndGet();
        if (newLockCount > 0) {
            return;
        }
        if (newLockCount < 0) {
            throw new IllegalMonitorStateException("Lock count has gone negative for lock: " + this.basePath);
        }
        try {
            this.internals.releaseLock(lockData.lockPath);
        }
        finally {
            this.threadData.remove(currentThread);
        }
    }

    public Collection<String> getParticipantNodes() throws Exception {
        return LockInternals.getParticipantNodes(this.internals.getClient(), this.basePath, this.internals.getLockName(), this.internals.getDriver());
    }

    @Override
    public void makeRevocable(RevocationListener<InterProcessMutex> listener) {
        this.makeRevocable(listener, MoreExecutors.directExecutor());
    }

    @Override
    public void makeRevocable(final RevocationListener<InterProcessMutex> listener, Executor executor) {
        this.internals.makeRevocable(new RevocationSpec(executor, new Runnable(){

            @Override
            public void run() {
                listener.revocationRequested(InterProcessMutex.this);
            }
        }));
    }

    InterProcessMutex(CuratorFramework client, String path, String lockName, int maxLeases, LockInternalsDriver driver) {
        this.basePath = PathUtils.validatePath(path);
        this.internals = new LockInternals(client, driver, path, lockName, maxLeases);
    }

    public boolean isOwnedByCurrentThread() {
        LockData lockData = (LockData)this.threadData.get(Thread.currentThread());
        return lockData != null && lockData.lockCount.get() > 0;
    }

    protected byte[] getLockNodeBytes() {
        return null;
    }

    protected String getLockPath() {
        LockData lockData = (LockData)this.threadData.get(Thread.currentThread());
        return lockData != null ? lockData.lockPath : null;
    }

    private boolean internalLock(long time, TimeUnit unit) throws Exception {
        Thread currentThread = Thread.currentThread();
        LockData lockData = (LockData)this.threadData.get(currentThread);
        if (lockData != null) {
            lockData.lockCount.incrementAndGet();
            return true;
        }
        String lockPath = this.internals.attemptLock(time, unit, this.getLockNodeBytes());
        if (lockPath != null) {
            LockData newLockData = new LockData(currentThread, lockPath);
            this.threadData.put(currentThread, newLockData);
            return true;
        }
        return false;
    }

    private static class LockData {
        final Thread owningThread;
        final String lockPath;
        final AtomicInteger lockCount = new AtomicInteger(1);

        private LockData(Thread owningThread, String lockPath) {
            this.owningThread = owningThread;
            this.lockPath = lockPath;
        }
    }
}

