/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.locks;

import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.WatcherRemoveCuratorFramework;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.locks.InterProcessLock;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.locks.InterProcessSemaphoreV2;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.recipes.locks.Lease;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.shaded.com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;

public class InterProcessSemaphoreMutex
implements InterProcessLock {
    private final InterProcessSemaphoreV2 semaphore;
    private final WatcherRemoveCuratorFramework watcherRemoveClient;
    private volatile Lease lease;

    public InterProcessSemaphoreMutex(CuratorFramework client, String path) {
        this.watcherRemoveClient = client.newWatcherRemoveCuratorFramework();
        this.semaphore = new InterProcessSemaphoreV2((CuratorFramework)this.watcherRemoveClient, path, 1);
    }

    @Override
    public void acquire() throws Exception {
        this.lease = this.semaphore.acquire();
    }

    @Override
    public boolean acquire(long time, TimeUnit unit) throws Exception {
        Lease acquiredLease = this.semaphore.acquire(time, unit);
        if (acquiredLease == null) {
            return false;
        }
        this.lease = acquiredLease;
        return true;
    }

    @Override
    public void release() throws Exception {
        Lease lease = this.lease;
        Preconditions.checkState(lease != null, "Not acquired");
        this.lease = null;
        lease.close();
        this.watcherRemoveClient.removeWatchers();
    }

    @Override
    public boolean isAcquiredInThisProcess() {
        return this.lease != null;
    }
}

