/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.state;

import com.alibaba.fluss.shaded.curator5.org.apache.curator.RetryPolicy;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.state.CircuitBreaker;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.state.ConnectionState;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.framework.state.ConnectionStateListener;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircuitBreakingConnectionStateListener
implements ConnectionStateListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final ConnectionStateListener listener;
    private final CircuitBreaker circuitBreaker;
    private boolean circuitLostHasBeenSent;
    private ConnectionState circuitLastState;
    private ConnectionState circuitInitialState;

    public CircuitBreakingConnectionStateListener(CuratorFramework client, ConnectionStateListener listener, RetryPolicy retryPolicy) {
        this(client, listener, CircuitBreaker.build(retryPolicy));
    }

    public CircuitBreakingConnectionStateListener(CuratorFramework client, ConnectionStateListener listener, RetryPolicy retryPolicy, ScheduledExecutorService service) {
        this(client, listener, CircuitBreaker.build(retryPolicy, service));
    }

    CircuitBreakingConnectionStateListener(CuratorFramework client, ConnectionStateListener listener, CircuitBreaker circuitBreaker) {
        this.client = Objects.requireNonNull(client, "client cannot be null");
        this.listener = Objects.requireNonNull(listener, "listener cannot be null");
        this.circuitBreaker = Objects.requireNonNull(circuitBreaker, "circuitBreaker cannot be null");
        this.reset();
    }

    @Override
    public synchronized void stateChanged(CuratorFramework client, ConnectionState newState) {
        if (this.circuitBreaker.isOpen()) {
            this.handleOpenStateChange(newState);
        } else {
            this.handleClosedStateChange(newState);
        }
    }

    public synchronized boolean isOpen() {
        return this.circuitBreaker.isOpen();
    }

    private synchronized void handleClosedStateChange(ConnectionState newState) {
        if (!newState.isConnected()) {
            if (this.circuitBreaker.tryToOpen(this::checkCloseCircuit)) {
                this.log.info("Circuit is opening. State: {} post-retryCount: {}", (Object)newState, (Object)this.circuitBreaker.getRetryCount());
                this.circuitLastState = this.circuitInitialState = newState;
                this.circuitLostHasBeenSent = newState == ConnectionState.LOST;
            } else {
                this.log.debug("Could not open circuit breaker. State: {}", (Object)newState);
            }
        }
        this.callListener(newState);
    }

    private synchronized void handleOpenStateChange(ConnectionState newState) {
        if (this.circuitLostHasBeenSent || newState != ConnectionState.LOST) {
            this.log.debug("Circuit is open. Ignoring state change: {}", (Object)newState);
            this.circuitLastState = newState;
        } else {
            this.log.debug("Circuit is open. State changed to LOST. Sending to listener.");
            this.circuitLostHasBeenSent = true;
            this.circuitLastState = this.circuitInitialState = ConnectionState.LOST;
            this.callListener(ConnectionState.LOST);
        }
    }

    private synchronized void checkCloseCircuit() {
        if (this.circuitLastState == null || this.circuitLastState.isConnected()) {
            this.log.info("Circuit is closing. Initial state: {} - Last state: {}", (Object)this.circuitInitialState, (Object)this.circuitLastState);
            this.closeCircuit();
        } else if (this.circuitBreaker.tryToRetry(this::checkCloseCircuit)) {
            this.log.debug("Circuit open is continuing due to retry. State: {} post-retryCount: {}", (Object)this.circuitLastState, (Object)this.circuitBreaker.getRetryCount());
        } else {
            this.log.info("Circuit is closing due to retries exhausted. Initial state: {} - Last state: {}", (Object)this.circuitInitialState, (Object)this.circuitLastState);
            this.closeCircuit();
        }
    }

    private synchronized void callListener(ConnectionState newState) {
        if (newState != null) {
            this.listener.stateChanged(this.client, newState);
        }
    }

    private synchronized void closeCircuit() {
        ConnectionState stateToSend = this.circuitLastState == this.circuitInitialState ? null : this.circuitLastState;
        this.reset();
        this.callListener(stateToSend);
    }

    private synchronized void reset() {
        this.circuitLastState = null;
        this.circuitInitialState = null;
        this.circuitLostHasBeenSent = false;
        this.circuitBreaker.close();
    }
}

