/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.shaded.curator5.org.apache.curator.retry;

import com.alibaba.fluss.shaded.curator5.org.apache.curator.RetryPolicy;
import com.alibaba.fluss.shaded.curator5.org.apache.curator.RetrySleeper;
import java.util.concurrent.TimeUnit;

abstract class SleepingRetry
implements RetryPolicy {
    private final int n;

    protected SleepingRetry(int n) {
        this.n = n;
    }

    public int getN() {
        return this.n;
    }

    @Override
    public boolean allowRetry(int retryCount, long elapsedTimeMs, RetrySleeper sleeper) {
        if (retryCount < this.n) {
            try {
                sleeper.sleepFor(this.getSleepTimeMs(retryCount, elapsedTimeMs), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            return true;
        }
        return false;
    }

    protected abstract long getSleepTimeMs(int var1, long var2);
}

