/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.shaded.zookeeper3.org.apache.jute.compiler;

import com.alibaba.fluss.shaded.zookeeper3.org.apache.jute.compiler.JCompType;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.jute.compiler.JRecord;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.jute.compiler.JType;

public class JVector
extends JCompType {
    private static int level = 0;
    private JType mElement;

    private static String getId(String id) {
        return id + JVector.getLevel();
    }

    private static String getLevel() {
        return Integer.toString(level);
    }

    private static void incrLevel() {
        ++level;
    }

    private static void decrLevel() {
        --level;
    }

    public JVector(JType t) {
        super("struct " + JVector.extractVectorName(t), " ::std::vector<" + t.getCppType() + ">", "System.Collections.Generic.List<" + t.getCsharpType() + ">", "java.util.List<" + t.getJavaType() + ">", "Vector", "System.Collections.Generic.List<" + t.getCsharpType() + ">", "java.util.ArrayList<" + t.getJavaType() + ">");
        this.mElement = t;
    }

    @Override
    public String getSignature() {
        return "[" + this.mElement.getSignature() + "]";
    }

    @Override
    public String genJavaCompareTo(String fname) {
        return "    throw new UnsupportedOperationException(\"comparing " + fname + " is unimplemented\");\n";
    }

    @Override
    public String genJavaReadWrapper(String fname, String tag, boolean decl) {
        StringBuilder ret = new StringBuilder("");
        if (decl) {
            ret.append("      java.util.List " + fname + ";\n");
        }
        ret.append("    {\n");
        JVector.incrLevel();
        ret.append("      Index " + JVector.getId("vidx") + " = a_.startVector(\"" + tag + "\");\n");
        ret.append("      if (" + JVector.getId("vidx") + "!= null) {");
        ret.append("          " + fname + "=new java.util.ArrayList<" + this.mElement.getJavaType() + ">();\n");
        ret.append("          for (; !" + JVector.getId("vidx") + ".done(); " + JVector.getId("vidx") + ".incr()) {\n");
        ret.append(this.mElement.genJavaReadWrapper(JVector.getId("e"), JVector.getId("e"), true));
        ret.append("            " + fname + ".add(" + JVector.getId("e") + ");\n");
        ret.append("          }\n");
        ret.append("      }\n");
        ret.append("    a_.endVector(\"" + tag + "\");\n");
        JVector.decrLevel();
        ret.append("    }\n");
        return ret.toString();
    }

    @Override
    public String genJavaReadMethod(String fname, String tag) {
        return this.genJavaReadWrapper(fname, tag, false);
    }

    @Override
    public String genJavaWriteWrapper(String fname, String tag) {
        StringBuilder ret = new StringBuilder("    {\n");
        JVector.incrLevel();
        ret.append("      a_.startVector(" + fname + ",\"" + tag + "\");\n");
        ret.append("      if (" + fname + "!= null) {");
        ret.append("          int " + JVector.getId("len") + " = " + fname + ".size();\n");
        ret.append("          for(int " + JVector.getId("vidx") + " = 0; " + JVector.getId("vidx") + "<" + JVector.getId("len") + "; " + JVector.getId("vidx") + "++) {\n");
        ret.append("            " + this.mElement.getJavaWrapperType() + " " + JVector.getId("e") + " = (" + this.mElement.getJavaWrapperType() + ") " + fname + ".get(" + JVector.getId("vidx") + ");\n");
        ret.append(this.mElement.genJavaWriteWrapper(JVector.getId("e"), JVector.getId("e")));
        ret.append("          }\n");
        ret.append("      }\n");
        ret.append("      a_.endVector(" + fname + ",\"" + tag + "\");\n");
        ret.append("    }\n");
        JVector.decrLevel();
        return ret.toString();
    }

    @Override
    public String genJavaWriteMethod(String fname, String tag) {
        return this.genJavaWriteWrapper(fname, tag);
    }

    public JType getElementType() {
        return this.mElement;
    }

    @Override
    public String genCsharpWriteWrapper(String fname, String tag) {
        StringBuilder ret = new StringBuilder("    {\n");
        JVector.incrLevel();
        ret.append("      a_.StartVector(" + JVector.capitalize(fname) + ",\"" + tag + "\");\n");
        ret.append("      if (" + JVector.capitalize(fname) + "!= null) {");
        ret.append("          int " + JVector.getId("len") + " = " + JVector.capitalize(fname) + ".Count;\n");
        ret.append("          for(int " + JVector.getId("vidx") + " = 0; " + JVector.getId("vidx") + "<" + JVector.getId("len") + "; " + JVector.getId("vidx") + "++) {\n");
        ret.append("            " + this.mElement.getCsharpWrapperType() + " " + JVector.getId("e") + " = (" + this.mElement.getCsharpWrapperType() + ") " + JVector.capitalize(fname) + "[" + JVector.getId("vidx") + "];\n");
        ret.append(this.mElement.genCsharpWriteWrapper(JVector.getId("e"), JVector.getId("e")));
        ret.append("          }\n");
        ret.append("      }\n");
        ret.append("      a_.EndVector(" + JVector.capitalize(fname) + ",\"" + tag + "\");\n");
        ret.append("    }\n");
        JVector.decrLevel();
        return ret.toString();
    }

    @Override
    String genCsharpWriteMethod(String fname, String tag) {
        return this.genCsharpWriteWrapper(fname, tag);
    }

    @Override
    public String genCsharpReadWrapper(String fname, String tag, boolean decl) {
        StringBuilder ret = new StringBuilder();
        if (decl) {
            ret.append("      System.Collections.Generic.List<" + this.mElement.getCsharpType() + "> " + JVector.capitalize(fname) + ";\n");
        }
        ret.append("    {\n");
        JVector.incrLevel();
        ret.append("      IIndex " + JVector.getId("vidx") + " = a_.StartVector(\"" + tag + "\");\n");
        ret.append("      if (" + JVector.getId("vidx") + "!= null) {");
        ret.append("          " + JVector.capitalize(fname) + "=new System.Collections.Generic.List<" + this.mElement.getCsharpType() + ">();\n");
        ret.append("          for (; !" + JVector.getId("vidx") + ".Done(); " + JVector.getId("vidx") + ".Incr()) {\n");
        ret.append(this.mElement.genCsharpReadWrapper(JVector.getId("e"), JVector.getId("e"), true));
        ret.append("            " + JVector.capitalize(fname) + ".Add(" + JVector.getId("e") + ");\n");
        ret.append("          }\n");
        ret.append("      }\n");
        ret.append("    a_.EndVector(\"" + tag + "\");\n");
        JVector.decrLevel();
        ret.append("    }\n");
        return ret.toString();
    }

    @Override
    String genCsharpReadMethod(String fname, String tag) {
        return this.genCsharpReadWrapper(fname, tag, false);
    }

    static String extractVectorName(JType jvType) {
        return JRecord.extractMethodSuffix(jvType) + "_vector";
    }
}

