/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.cli;

import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.KeeperException;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.ZKUtil;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.cli.CliCommand;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.cli.CliException;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.cli.CliParseException;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.cli.CliWrapperException;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.cli.MalformedPathException;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.cli.StatPrinter;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.data.ACL;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.data.Stat;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class GetAclCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public GetAclCommand() {
        super("getAcl", "[-s] path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        DefaultParser parser = new DefaultParser();
        try {
            this.cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        List<ACL> acl;
        String path = this.args[1];
        Stat stat = new Stat();
        try {
            acl = this.zk.getACL(path, stat);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        for (ACL a : acl) {
            this.out.println(a.getId() + ": " + ZKUtil.getPermString(a.getPerms()));
        }
        if (this.cl.hasOption("s")) {
            new StatPrinter(this.out).print(stat);
        }
        return false;
    }

    static {
        options.addOption("s", false, "stats");
    }
}

