/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.server.metric;

import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.metrics.SummarySet;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.server.metric.AvgMinMaxPercentileCounter;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.server.metric.Metric;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AvgMinMaxPercentileCounterSet
extends Metric
implements SummarySet {
    private final String name;
    private ConcurrentHashMap<String, AvgMinMaxPercentileCounter> counters = new ConcurrentHashMap();

    public AvgMinMaxPercentileCounterSet(String name) {
        this.name = name;
    }

    private AvgMinMaxPercentileCounter getCounterForKey(String key) {
        AvgMinMaxPercentileCounter counter = this.counters.get(key);
        if (counter == null) {
            this.counters.putIfAbsent(key, new AvgMinMaxPercentileCounter(key + "_" + this.name));
            counter = this.counters.get(key);
        }
        return counter;
    }

    public void addDataPoint(String key, long value) {
        this.getCounterForKey(key).addDataPoint(value);
    }

    public void resetMax() {
        for (Map.Entry<String, AvgMinMaxPercentileCounter> entry : this.counters.entrySet()) {
            entry.getValue().resetMax();
        }
    }

    @Override
    public void reset() {
        for (Map.Entry<String, AvgMinMaxPercentileCounter> entry : this.counters.entrySet()) {
            entry.getValue().reset();
        }
    }

    @Override
    public void add(String key, long value) {
        this.addDataPoint(key, value);
    }

    @Override
    public Map<String, Object> values() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, AvgMinMaxPercentileCounter> entry : this.counters.entrySet()) {
            m.putAll(entry.getValue().values());
        }
        return m;
    }
}

