/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.server.quorum;

import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.server.ZooKeeperServer;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.server.ZooKeeperServerBean;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.server.quorum.Leader;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.server.quorum.LeaderMXBean;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.server.quorum.LearnerHandler;
import com.alibaba.fluss.shaded.zookeeper3.org.apache.zookeeper.server.quorum.QuorumPeer;

public class LeaderBean
extends ZooKeeperServerBean
implements LeaderMXBean {
    private final Leader leader;

    public LeaderBean(Leader leader, ZooKeeperServer zks) {
        super(zks);
        this.leader = leader;
    }

    @Override
    public String getName() {
        return "Leader";
    }

    @Override
    public String getCurrentZxid() {
        return "0x" + Long.toHexString(this.zks.getZxid());
    }

    @Override
    public String followerInfo() {
        StringBuilder sb = new StringBuilder();
        for (LearnerHandler handler : this.leader.getLearners()) {
            if (handler.getLearnerType() != QuorumPeer.LearnerType.PARTICIPANT) continue;
            sb.append(handler.toString()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public String nonVotingFollowerInfo() {
        StringBuilder sb = new StringBuilder();
        for (LearnerHandler handler : this.leader.getNonVotingFollowers()) {
            sb.append(handler.toString()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public long getElectionTimeTaken() {
        return this.leader.self.getElectionTimeTaken();
    }

    @Override
    public int getLastProposalSize() {
        return this.leader.getProposalStats().getLastBufferSize();
    }

    @Override
    public int getMinProposalSize() {
        return this.leader.getProposalStats().getMinBufferSize();
    }

    @Override
    public int getMaxProposalSize() {
        return this.leader.getProposalStats().getMaxBufferSize();
    }

    @Override
    public void resetProposalStatistics() {
        this.leader.getProposalStats().reset();
    }

    @Override
    public int getMaxConcurrentSnapSyncs() {
        return this.leader.getMaxConcurrentSnapSyncs();
    }

    @Override
    public void setMaxConcurrentSnapSyncs(int maxConcurrentSnapshots) {
        this.leader.setMaxConcurrentSnapSyncs(maxConcurrentSnapshots);
    }

    @Override
    public int getMaxConcurrentDiffSyncs() {
        return this.leader.getMaxConcurrentDiffSyncs();
    }

    @Override
    public void setMaxConcurrentDiffSyncs(int maxConcurrentDiffSyncs) {
        this.leader.setMaxConcurrentDiffSyncs(maxConcurrentDiffSyncs);
    }
}

