/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.testutils.common;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Fail;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CommonTestUtils.class);

    public static void waitUtil(ThrowingSupplier<Boolean> condition, Duration timeout, Duration pause, String errorMsg) {
        boolean conditionResult;
        long timeoutMs = timeout.toMillis();
        if (timeoutMs <= 0L) {
            throw new IllegalArgumentException("The timeout must be positive.");
        }
        long startingTime = System.currentTimeMillis();
        try {
            conditionResult = (Boolean)condition.get();
            while (!conditionResult && System.currentTimeMillis() - startingTime < timeoutMs) {
                conditionResult = (Boolean)condition.get();
                Thread.sleep(pause.toMillis());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        if (!conditionResult) {
            Fail.fail((String)errorMsg);
        }
    }

    public static void waitUtil(ThrowingSupplier<Boolean> condition, Duration timeout, String errorMsg) {
        CommonTestUtils.waitUtil(condition, timeout, Duration.ofMillis(1L), errorMsg);
    }

    public static <T> T waitValue(ThrowingSupplier<Optional<T>> supplier, Duration timeout, String errorMsg) {
        AtomicReference result = new AtomicReference();
        CommonTestUtils.waitUtil((ThrowingSupplier<Boolean>)((ThrowingSupplier)() -> {
            Optional opt = (Optional)supplier.get();
            if (opt.isPresent()) {
                result.set(opt.get());
                return true;
            }
            return false;
        }), timeout, errorMsg);
        return (T)result.get();
    }

    /*
     * Loose catch block
     */
    public static void retry(Duration timeout, Executable assertion) {
        long maxWaitMs = timeout.toMillis();
        long waitMs = 1L;
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                assertion.execute();
                return;
            }
            catch (AssertionError t) {
                if (System.currentTimeMillis() - startTime >= maxWaitMs) {
                    throw t;
                }
                LOG.info("Attempt failed, sleeping for {} ms, and then retrying.", (Object)waitMs);
                try {
                    Thread.sleep(waitMs);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                waitMs += Math.min(waitMs, 1000L);
                continue;
            }
            break;
        }
        catch (Throwable t) {
            throw new AssertionError("Attempt failed.", t);
        }
    }

    public static void setEnv(Map<String, String> newenv) {
        CommonTestUtils.setEnv(newenv, true);
    }

    public static void setEnv(Map<String, String> newenv, boolean clearExisting) {
        try {
            Map<String, String> env = System.getenv();
            Class<?> clazz = env.getClass();
            Field field = clazz.getDeclaredField("m");
            field.setAccessible(true);
            Map map = (Map)field.get(env);
            if (clearExisting) {
                map.clear();
            }
            map.putAll(newenv);
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            try {
                Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField("theCaseInsensitiveEnvironment");
                theCaseInsensitiveEnvironmentField.setAccessible(true);
                Map cienv = (Map)theCaseInsensitiveEnvironmentField.get(null);
                if (clearExisting) {
                    cienv.clear();
                }
                cienv.putAll(newenv);
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    public static String getCurrentClasspath() {
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        return bean.getClassPath();
    }

    public static String getJavaCommandPath() {
        Process process;
        ProcessBuilder bld2;
        File javaHome = new File(System.getProperty("java.home"));
        String path1 = new File(javaHome, "java").getAbsolutePath();
        String path2 = new File(new File(javaHome, "bin"), "java").getAbsolutePath();
        try {
            bld2 = new ProcessBuilder(path1, "-version");
            process = bld2.start();
            if (process.waitFor() == 0) {
                return path1;
            }
        }
        catch (Throwable bld2) {
            // empty catch block
        }
        try {
            bld2 = new ProcessBuilder(path2, "-version");
            process = bld2.start();
            if (process.waitFor() == 0) {
                return path2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static void printLog4jDebugConfig(File file) throws IOException {
        try (PrintWriter writer = new PrintWriter(new FileWriter(file));){
            writer.println("rootLogger.level = DEBUG");
            writer.println("rootLogger.appenderRef.console.ref = ConsoleAppender");
            writer.println("appender.console.name = ConsoleAppender");
            writer.println("appender.console.type = CONSOLE");
            writer.println("appender.console.target = SYSTEM_OUT");
            writer.println("appender.console.layout.type = PatternLayout");
            writer.println("appender.console.layout.pattern = %d{HH:mm:ss,SSS} %-4r [%t] %-5p %c %x - %m%n");
            writer.println("logger.jetty.name = org.eclipse.jetty.util.log");
            writer.println("logger.jetty.level = OFF");
            writer.println("logger.zookeeper.name = org.apache.zookeeper");
            writer.println("logger.zookeeper.level = OFF");
            writer.flush();
        }
    }

    public static class PipeForwarder
    extends Thread {
        private final StringWriter target;
        private final InputStream source;

        public PipeForwarder(InputStream source, StringWriter target) {
            super("Pipe Forwarder");
            this.setDaemon(true);
            this.source = source;
            this.target = target;
            this.start();
        }

        @Override
        public void run() {
            try {
                int next;
                while ((next = this.source.read()) != -1) {
                    this.target.write(next);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

