/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.testutils.common;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ContextClassLoaderExtension
implements BeforeAllCallback,
AfterAllCallback {
    private File tempDir;
    private final Function<File, URLClassLoader> temporaryClassLoaderFactory;
    private ClassLoader originalClassLoader;
    private URLClassLoader temporaryClassLoader;

    private ContextClassLoaderExtension(Function<File, URLClassLoader> temporaryClassLoaderFactory) {
        this.temporaryClassLoaderFactory = temporaryClassLoaderFactory;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.tempDir = Files.createTempDirectory("fluss-testing-context-classloader", new FileAttribute[0]).toFile();
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
        this.temporaryClassLoader = this.temporaryClassLoaderFactory.apply(this.tempDir);
        Thread.currentThread().setContextClassLoader(this.temporaryClassLoader);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        this.temporaryClassLoader.close();
        this.tempDir.delete();
    }

    public static ContextClassLoaderExtensionBuilder builder() {
        return new ContextClassLoaderExtensionBuilder();
    }

    private static URLClassLoader setupClassLoader(File temporaryFolder, Collection<ServiceEntry> serviceEntries) {
        Path root = temporaryFolder.toPath();
        try {
            ContextClassLoaderExtension.writeServiceEntries(root, serviceEntries);
            URL url = temporaryFolder.toPath().toUri().toURL();
            return new URLClassLoader(new URL[]{url}, ContextClassLoaderExtension.class.getClassLoader());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeServiceEntries(Path tmpDir, Collection<ServiceEntry> serviceEntries) throws IOException {
        for (ServiceEntry serviceEntry : serviceEntries) {
            Path path = tmpDir.resolve(Paths.get("META-INF", "services", serviceEntry.serviceClass.getCanonicalName()));
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, (Iterable<? extends CharSequence>)serviceEntry.serviceImplementations, StandardOpenOption.CREATE);
        }
    }

    private static class ServiceEntry {
        private final Class<?> serviceClass;
        private final List<String> serviceImplementations;

        public ServiceEntry(Class<?> serviceClass, String ... serviceImplementations) {
            this.serviceClass = serviceClass;
            this.serviceImplementations = Arrays.asList(serviceImplementations);
        }
    }

    public static class ContextClassLoaderExtensionBuilder {
        private final Collection<ServiceEntry> serviceEntries = new ArrayList<ServiceEntry>();

        public ContextClassLoaderExtensionBuilder withServiceEntry(Class<?> serviceClass, String ... serviceImplementations) {
            this.serviceEntries.add(new ServiceEntry(serviceClass, serviceImplementations));
            return this;
        }

        public ContextClassLoaderExtension build() {
            Function<File, URLClassLoader> factory = temporaryFolder -> ContextClassLoaderExtension.setupClassLoader(temporaryFolder, this.serviceEntries);
            return new ContextClassLoaderExtension(factory);
        }

        private ContextClassLoaderExtensionBuilder() {
        }
    }
}

