/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient.dualservice;

import com.alibaba.hbase.haclient.dualservice.AutoSwitch;
import com.alibaba.hbase.haclient.dualservice.DualContext;
import com.alibaba.hbase.haclient.dualservice.ExecuteCounter;
import com.alibaba.hbase.haclient.dualservice.ResultCounter;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class ConnectionCounter
implements ExecuteCounter {
    private static final Log LOG = LogFactory.getLog(ConnectionCounter.class);
    private ResultCounter resultCounter;
    private boolean switchStatus = false;
    private Configuration conf;
    private int activeFailLimit;
    private float activeFailLimitPercentage;
    private int standbySuccessLimit;
    private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);

    public ConnectionCounter(Configuration conf) {
        this.conf = conf;
        this.resultCounter = new ResultCounter(ResultCounter.CountStrategy.PERCENTAGE);
        this.activeFailLimit = this.conf.getInt("connection.autoswitch.active.fail.limit", 50);
        this.activeFailLimitPercentage = this.conf.getFloat("connection.autoswitch.active.fail.limit.percentage", 0.1f);
        this.standbySuccessLimit = this.conf.getInt("connection.autoswitch.standby.success.limit", 5);
        long period = conf.getLong("hbase.autoswitch.counter.clear.interval", 10000L);
        this.scheduledExecutorService.scheduleAtFixedRate(new Thread("connection-counter"){

            @Override
            public void run() {
                ConnectionCounter.this.resultCounter.updateActiveErrorPercentage();
            }
        }, period, period, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized <T> void update(DualContext<T> dualContext) {
        boolean isSwitch = this.isSwitchStatus(dualContext);
        if (dualContext.getExecuteStrategy() == AutoSwitch.ExecuteStrategy.DEFAULT && isSwitch) {
            return;
        }
        if (dualContext.getExecuteStrategy() == AutoSwitch.ExecuteStrategy.SWITCH && !isSwitch) {
            return;
        }
        this.resultCounter.increment(dualContext);
    }

    @Override
    public synchronized <T> boolean isSwitchStatus(DualContext<T> dualContext) {
        return this.switchStatus;
    }

    @Override
    public synchronized <T> void setSwitchStatus(DualContext<T> dualContext, boolean switchStatus) {
        this.switchStatus = switchStatus;
        this.reset(dualContext);
    }

    @Override
    public synchronized <T> boolean reachLimit(DualContext<T> dualContext) {
        boolean result;
        if (!this.switchStatus) {
            result = this.resultCounter.getActiveFailCount() > (long)this.activeFailLimit || this.resultCounter.getActiveFailPercentage() > (double)this.activeFailLimitPercentage;
        } else {
            boolean bl = result = this.resultCounter.getStandbySuccessCount() > (long)this.standbySuccessLimit;
        }
        if (result) {
            LOG.debug((Object)("Reach limit active fail count=" + this.activeFailLimit + ", active fail count percentage=" + this.resultCounter.getActiveFailPercentage() + ", standby success count=" + this.resultCounter.getStandbySuccessCount() + ", total fail count=" + this.resultCounter.getTotalActiveFailCount()));
        }
        return result;
    }

    @Override
    public synchronized <T> void reset(DualContext<T> dualContext) {
        this.resultCounter.totalAndActiveCountClear();
        this.resultCounter.activeCountClear();
        this.resultCounter.standbyCountClear();
    }
}

