/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient.dualservice;

import com.alibaba.hbase.haclient.dualservice.DualContext;
import com.alibaba.hbase.haclient.dualservice.DualExecutor;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;

public class DualCallable<T, V>
implements Callable<T> {
    private DualContext<T> context;
    private HTable htable;
    private V action;
    private DualExecutor.ActionType actionType;
    private DualExecutor.Role role;

    public DualCallable(DualContext<T> context, HTable htable, V action, DualExecutor.ActionType actionType, DualExecutor.Role role) {
        this.context = context;
        this.htable = htable;
        this.action = action;
        this.actionType = actionType;
        this.role = role;
    }

    @Override
    public T call() throws Exception {
        try {
            Result[] result = null;
            switch (this.actionType) {
                case GET: {
                    result = this.htable.get((Get)this.action);
                    break;
                }
                case PUT: {
                    this.htable.put((Put)this.action);
                    break;
                }
                case DELETE: {
                    this.htable.delete((Delete)this.action);
                    break;
                }
                case BATCHGET: {
                    result = this.htable.get((List)this.action);
                    break;
                }
                case BATCHPUT: {
                    this.htable.put((List)this.action);
                    break;
                }
                case BATCHDELETE: {
                    this.htable.delete((List)this.action);
                }
            }
            if (this.role == DualExecutor.Role.ACTIVE) {
                this.context.onActiveComplete(result);
            } else {
                this.context.onStandbyComplete(result);
            }
            return (T)result;
        }
        catch (Throwable t) {
            if (this.role == DualExecutor.Role.ACTIVE) {
                this.context.onActiveError(t);
            } else {
                this.context.onStandbyError(t);
            }
            return null;
        }
    }
}

