/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient.dualservice;

import com.alibaba.hbase.haclient.dualservice.AutoSwitch;
import com.alibaba.hbase.haclient.dualservice.DualContext;
import com.alibaba.hbase.haclient.dualservice.ExecuteCounter;
import com.alibaba.hbase.haclient.dualservice.ResultCounter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;

public class TableCounter
implements ExecuteCounter {
    private static final Log LOG = LogFactory.getLog(TableCounter.class);
    private ConcurrentHashMap<String, ResultCounter> tableCounters;
    private ConcurrentHashMap<String, Boolean> tableSwitchStatus;
    private Configuration conf;
    private int activeFailLimit;
    private float activeFailLimitPercentage;
    private int standbySuccessLimit;
    private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);

    public TableCounter(Configuration conf) {
        this.conf = conf;
        this.tableCounters = new ConcurrentHashMap();
        this.tableSwitchStatus = new ConcurrentHashMap();
        this.activeFailLimit = this.conf.getInt("table.autoswitch.active.fail.limit", 25);
        this.activeFailLimitPercentage = this.conf.getFloat("table.autoswitch.active.fail.limit.percentage", 0.1f);
        this.standbySuccessLimit = this.conf.getInt("table.autoswitch.standby.success.limit", 3);
        long period = conf.getLong("hbase.autoswitch.counter.clear.interval", 10000L);
        this.scheduledExecutorService.scheduleAtFixedRate(new Thread("table-counter"){

            @Override
            public void run() {
                for (Map.Entry entry : TableCounter.this.tableCounters.entrySet()) {
                    ((ResultCounter)entry.getValue()).updateActiveErrorPercentage();
                }
            }
        }, period, period, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized <T> void update(DualContext<T> dualContext) {
        boolean isSwitch = this.isSwitchStatus(dualContext);
        if (dualContext.getExecuteStrategy() == AutoSwitch.ExecuteStrategy.DEFAULT && isSwitch) {
            return;
        }
        if (dualContext.getExecuteStrategy() == AutoSwitch.ExecuteStrategy.SWITCH && !isSwitch) {
            return;
        }
        String tableNameAsString = TableName.valueOf((byte[])dualContext.getTableName()).getNameAsString();
        if (this.tableCounters.containsKey(tableNameAsString)) {
            this.tableCounters.get(tableNameAsString).increment(dualContext);
        } else {
            ResultCounter newCounter = new ResultCounter(ResultCounter.CountStrategy.PERCENTAGE);
            newCounter.increment(dualContext);
            this.tableCounters.put(tableNameAsString, newCounter);
        }
    }

    @Override
    public synchronized <T> boolean isSwitchStatus(DualContext<T> dualContext) {
        String tableNameAsString = TableName.valueOf((byte[])dualContext.getTableName()).getNameAsString();
        if (this.tableSwitchStatus.containsKey(tableNameAsString)) {
            return this.tableSwitchStatus.get(tableNameAsString);
        }
        this.tableSwitchStatus.put(tableNameAsString, false);
        return false;
    }

    @Override
    public synchronized <T> void setSwitchStatus(DualContext<T> dualContext, boolean switchStatus) {
        String tableNameAsString = TableName.valueOf((byte[])dualContext.getTableName()).getNameAsString();
        this.tableSwitchStatus.put(tableNameAsString, switchStatus);
        this.reset(dualContext);
    }

    @Override
    public synchronized <T> boolean reachLimit(DualContext<T> dualContext) {
        boolean result;
        String tableNameAsString = TableName.valueOf((byte[])dualContext.getTableName()).getNameAsString();
        ResultCounter resultCounter = null;
        resultCounter = this.tableCounters.get(tableNameAsString);
        if (resultCounter == null) {
            return false;
        }
        if (!this.isSwitchStatus(dualContext)) {
            result = resultCounter.getActiveFailCount() > (long)this.activeFailLimit || resultCounter.getActiveFailPercentage() > (double)this.activeFailLimitPercentage;
        } else {
            boolean bl = result = resultCounter.getStandbySuccessCount() > (long)this.standbySuccessLimit;
        }
        if (result) {
            LOG.debug((Object)("Reach limit active fail count=" + this.activeFailLimit + ", active fail count percentage=" + resultCounter.getActiveFailPercentage() + ", standby success count=" + resultCounter.getStandbySuccessCount() + ", total fail count=" + resultCounter.getTotalActiveFailCount()));
        }
        return result;
    }

    @Override
    public synchronized <T> void reset(DualContext<T> dualContext) {
        String tableNameAsString = TableName.valueOf((byte[])dualContext.getTableName()).getNameAsString();
        if (this.tableCounters.containsKey(tableNameAsString)) {
            this.tableCounters.get(tableNameAsString).totalAndActiveCountClear();
            this.tableCounters.get(tableNameAsString).activeCountClear();
            this.tableCounters.get(tableNameAsString).standbyCountClear();
        }
    }
}

