/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.util;

import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.math.BigDecimal;
import org.apache.hadoop.hbase.client.index.AliHBaseColumn;

public class OrderedBytes {
    public static byte[] toBytes(byte val) {
        byte[] output = new byte[1];
        DataTypeUtils.encodeByte(val, output, 0, SortOrder.getDefault());
        return output;
    }

    public static int putByte(byte[] output, int offset, byte val) {
        return offset + DataTypeUtils.encodeByte(val, output, offset, SortOrder.getDefault());
    }

    public static byte toByte(byte[] bytes) {
        return DataTypeUtils.decodeByte(bytes, 0, SortOrder.getDefault());
    }

    public static byte toByte(byte[] bytes, int offset) {
        return DataTypeUtils.decodeByte(bytes, offset, SortOrder.getDefault());
    }

    public static byte[] toBytes(short val) {
        byte[] output = new byte[2];
        DataTypeUtils.encodeShort(val, output, 0, SortOrder.getDefault());
        return output;
    }

    public static int putShort(byte[] output, int offset, short val) {
        return offset + DataTypeUtils.encodeShort(val, output, offset, SortOrder.getDefault());
    }

    public static short toShort(byte[] bytes) {
        return DataTypeUtils.decodeShort(bytes, 0, SortOrder.getDefault());
    }

    public static short toShort(byte[] bytes, int offset) {
        return DataTypeUtils.decodeShort(bytes, offset, SortOrder.getDefault());
    }

    public static byte[] toBytes(int val) {
        byte[] output = new byte[4];
        DataTypeUtils.encodeInt(val, output, 0, SortOrder.getDefault());
        return output;
    }

    public static int putInt(byte[] output, int offset, int val) {
        return offset + DataTypeUtils.encodeInt(val, output, offset, SortOrder.getDefault());
    }

    public static int toInt(byte[] bytes) {
        return DataTypeUtils.decodeInt(bytes, 0, SortOrder.getDefault());
    }

    public static int toInt(byte[] bytes, int offset) {
        return DataTypeUtils.decodeInt(bytes, offset, SortOrder.getDefault());
    }

    public static byte[] toBytes(long val) {
        byte[] output = new byte[8];
        DataTypeUtils.encodeLong(val, output, 0, SortOrder.getDefault());
        return output;
    }

    public static int putLong(byte[] output, int offset, long val) {
        return offset + DataTypeUtils.encodeLong(val, output, offset, SortOrder.getDefault());
    }

    public static long toLong(byte[] bytes) {
        return DataTypeUtils.decodeLong(bytes, 0, SortOrder.getDefault());
    }

    public static long toLong(byte[] bytes, int offset) {
        return DataTypeUtils.decodeLong(bytes, offset, SortOrder.getDefault());
    }

    public static byte[] toBytes(float val) {
        byte[] output = new byte[4];
        DataTypeUtils.encodeFloat(val, output, 0, SortOrder.getDefault());
        return output;
    }

    public static int putFloat(byte[] output, int offset, float val) {
        return offset + DataTypeUtils.encodeFloat(val, output, offset, SortOrder.getDefault());
    }

    public static float toFloat(byte[] bytes) {
        return DataTypeUtils.decodeFloat(bytes, 0, SortOrder.getDefault());
    }

    public static float toFloat(byte[] bytes, int offset) {
        return DataTypeUtils.decodeFloat(bytes, offset, SortOrder.getDefault());
    }

    public static byte[] toBytes(double val) {
        byte[] output = new byte[8];
        DataTypeUtils.encodeDouble(val, output, 0, SortOrder.getDefault());
        return output;
    }

    public static int putDouble(byte[] output, int offset, double val) {
        return offset + DataTypeUtils.encodeDouble(val, output, offset, SortOrder.getDefault());
    }

    public static double toDouble(byte[] bytes) {
        return DataTypeUtils.decodeDouble(bytes, 0, SortOrder.getDefault());
    }

    public static double toDouble(byte[] bytes, int offset) {
        return DataTypeUtils.decodeDouble(bytes, offset, SortOrder.getDefault());
    }

    public static byte[] toBytes(BigDecimal val) {
        return DataTypeUtils.encodeDecimal(val, SortOrder.getDefault());
    }

    public static int putBigDecimal(byte[] output, int offset, BigDecimal val) {
        byte[] temp = DataTypeUtils.encodeDecimal(val, SortOrder.getDefault());
        System.arraycopy(temp, 0, output, offset, temp.length);
        return offset + temp.length;
    }

    public static BigDecimal toBigDecimal(byte[] bytes) {
        return DataTypeUtils.decodeDecimal(bytes, 0, bytes.length, SortOrder.getDefault());
    }

    public static BigDecimal toBigDecimal(byte[] bytes, int offset, int length) {
        return DataTypeUtils.decodeDecimal(bytes, offset, length, SortOrder.getDefault());
    }

    public static byte[] toBytes(byte val, AliHBaseColumn.SortOrder order) {
        byte[] output = new byte[1];
        DataTypeUtils.encodeByte(val, output, 0, order.getImplSortOrder());
        return output;
    }

    public static int putByte(byte[] output, int offset, byte val, AliHBaseColumn.SortOrder order) {
        return offset + DataTypeUtils.encodeByte(val, output, offset, order.getImplSortOrder());
    }

    public static byte toByte(byte[] bytes, AliHBaseColumn.SortOrder order) {
        return DataTypeUtils.decodeByte(bytes, 0, order.getImplSortOrder());
    }

    public static byte toByte(byte[] bytes, int offset, AliHBaseColumn.SortOrder order) {
        return DataTypeUtils.decodeByte(bytes, offset, order.getImplSortOrder());
    }

    public static byte[] toBytes(short val, AliHBaseColumn.SortOrder order) {
        byte[] output = new byte[2];
        DataTypeUtils.encodeShort(val, output, 0, order.getImplSortOrder());
        return output;
    }

    public static int putShort(byte[] output, int offset, short val, AliHBaseColumn.SortOrder order) {
        return offset + DataTypeUtils.encodeShort(val, output, offset, order.getImplSortOrder());
    }

    public static short toShort(byte[] bytes, AliHBaseColumn.SortOrder order) {
        return DataTypeUtils.decodeShort(bytes, 0, order.getImplSortOrder());
    }

    public static short toShort(byte[] bytes, int offset, AliHBaseColumn.SortOrder order) {
        return DataTypeUtils.decodeShort(bytes, offset, order.getImplSortOrder());
    }

    public static byte[] toBytes(int val, AliHBaseColumn.SortOrder order) {
        byte[] output = new byte[4];
        DataTypeUtils.encodeInt(val, output, 0, order.getImplSortOrder());
        return output;
    }

    public static int putInt(byte[] output, int offset, int val, AliHBaseColumn.SortOrder order) {
        return offset + DataTypeUtils.encodeInt(val, output, offset, order.getImplSortOrder());
    }

    public static int toInt(byte[] bytes, AliHBaseColumn.SortOrder order) {
        return DataTypeUtils.decodeInt(bytes, 0, order.getImplSortOrder());
    }

    public static int toInt(byte[] bytes, int offset, AliHBaseColumn.SortOrder order) {
        return DataTypeUtils.decodeInt(bytes, offset, order.getImplSortOrder());
    }

    public static byte[] toBytes(long val, AliHBaseColumn.SortOrder order) {
        byte[] output = new byte[8];
        DataTypeUtils.encodeLong(val, output, 0, order.getImplSortOrder());
        return output;
    }

    public static int putLong(byte[] output, int offset, long val, AliHBaseColumn.SortOrder order) {
        return offset + DataTypeUtils.encodeLong(val, output, offset, order.getImplSortOrder());
    }

    public static long toLong(byte[] bytes, AliHBaseColumn.SortOrder order) {
        return DataTypeUtils.decodeLong(bytes, 0, order.getImplSortOrder());
    }

    public static long toLong(byte[] bytes, int offset, AliHBaseColumn.SortOrder order) {
        return DataTypeUtils.decodeLong(bytes, offset, order.getImplSortOrder());
    }

    public static byte[] toBytes(float val, AliHBaseColumn.SortOrder order) {
        byte[] output = new byte[4];
        DataTypeUtils.encodeFloat(val, output, 0, order.getImplSortOrder());
        return output;
    }

    public static int putFloat(byte[] output, int offset, float val, AliHBaseColumn.SortOrder order) {
        return offset + DataTypeUtils.encodeFloat(val, output, offset, order.getImplSortOrder());
    }

    public static float toFloat(byte[] bytes, AliHBaseColumn.SortOrder order) {
        return DataTypeUtils.decodeFloat(bytes, 0, order.getImplSortOrder());
    }

    public static float toFloat(byte[] bytes, int offset, AliHBaseColumn.SortOrder order) {
        return DataTypeUtils.decodeFloat(bytes, offset, order.getImplSortOrder());
    }

    public static byte[] toBytes(double val, AliHBaseColumn.SortOrder order) {
        byte[] output = new byte[8];
        DataTypeUtils.encodeDouble(val, output, 0, order.getImplSortOrder());
        return output;
    }

    public static int putDouble(byte[] output, int offset, double val, AliHBaseColumn.SortOrder order) {
        return offset + DataTypeUtils.encodeDouble(val, output, offset, order.getImplSortOrder());
    }

    public static double toDouble(byte[] bytes, AliHBaseColumn.SortOrder order) {
        return DataTypeUtils.decodeDouble(bytes, 0, order.getImplSortOrder());
    }

    public static double toDouble(byte[] bytes, int offset, AliHBaseColumn.SortOrder order) {
        return DataTypeUtils.decodeDouble(bytes, offset, order.getImplSortOrder());
    }

    public static byte[] toBytes(BigDecimal val, AliHBaseColumn.SortOrder order) {
        return DataTypeUtils.encodeDecimal(val, order.getImplSortOrder());
    }

    public static int putBigDecimal(byte[] output, int offset, BigDecimal val, AliHBaseColumn.SortOrder order) {
        byte[] temp = DataTypeUtils.encodeDecimal(val, order.getImplSortOrder());
        System.arraycopy(temp, 0, output, offset, temp.length);
        return offset + temp.length;
    }

    public static BigDecimal toBigDecimal(byte[] bytes, AliHBaseColumn.SortOrder order) {
        return DataTypeUtils.decodeDecimal(bytes, 0, bytes.length, order.getImplSortOrder());
    }

    public static BigDecimal toBigDecimal(byte[] bytes, int offset, int length, AliHBaseColumn.SortOrder order) {
        return DataTypeUtils.decodeDecimal(bytes, offset, length, order.getImplSortOrder());
    }
}

