/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.LindormClientConstants;
import com.alibaba.lindorm.client.core.ipc.BlobClient;
import com.alibaba.lindorm.client.core.ipc.ConfigObserver;
import com.alibaba.lindorm.client.core.ipc.LConnection;
import com.alibaba.lindorm.client.core.ipc.LConnectionManager;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.ipc.RetryingCaller;
import com.alibaba.lindorm.client.core.utils.ClientEnvLogUtil;
import com.alibaba.lindorm.client.core.utils.ConfigUtil;
import com.alibaba.lindorm.client.core.utils.RatedLog;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.tracer.EagleEyeTracer;
import com.alibaba.lindorm.client.tracer.Tracer;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LindormBasicService
implements ConfigObserver,
Tracer {
    public static final Log LOG = LogFactory.getLog(LindormBasicService.class);
    public static final RatedLog SLOW_TRACE = new RatedLog(LOG, 1, 60000L);
    protected LConnection lconnection;
    protected BlobClient blobClient;
    protected LindormClientConfig config;
    protected String namespace;
    protected volatile boolean closed;
    protected int operationTimeout;
    protected int glitchTimeout;
    protected int ddlOperationTimeout;
    protected int maxRetryDDL;
    protected int ddlPause;
    protected int systemOperationTimeout;
    protected final String serviceName;
    protected String doAsUser = null;
    protected boolean eagleeyeEnabled = false;
    protected Tracer tracer = null;
    protected long slowTraceThreshold = 0L;
    protected boolean clientRetryIfQuotaExceeded;
    protected boolean initCauseBy;

    public LindormBasicService() {
        this.serviceName = "test";
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LindormBasicService(LindormClientConfig config, String serviceName) throws LindormException {
        boolean success;
        this.config = config;
        this.serviceName = serviceName;
        this.namespace = config.getNamespace();
        String timeOutKey = ConfigUtil.createServiceConfKey(serviceName, "lindorm.client.timeout");
        this.operationTimeout = config.getInt(timeOutKey, config.getInt("lindorm.client.timeout", 120000));
        String glitchKey = ConfigUtil.createServiceConfKey(serviceName, "lindorm.rpc.glitchtime");
        this.glitchTimeout = config.getInt(glitchKey, config.getInt("lindorm.rpc.glitchtime", -1));
        this.systemOperationTimeout = this.config.getInt("lindorm.client.system.timeout", 60000);
        this.ddlOperationTimeout = config.getInt("lindorm.client.ddl.timeout", 180000);
        this.maxRetryDDL = config.getInt("lindorm.client.ddl.max.retries.number", 300);
        this.ddlPause = config.getInt("lindorm.client.ddl.query.pause", 1000);
        this.clientRetryIfQuotaExceeded = config.getBoolean("lindorm.client.retry.if.quota.exceeded", true);
        this.initCauseBy = config.getBoolean("lindorm.client.init.causeby", LindormClientConstants.LINDORM_CLIENT_INIT_CAUSEBY_DEFAULT);
        try {
            this.lconnection = LConnectionManager.getLConnection(config);
        }
        catch (IOException ioe) {
            String seedServer = config.getSeedServer();
            String user = config.getUser();
            LOG.error((Object)("getLConnection failed, seedServer:" + seedServer + " user:" + user), (Throwable)ioe);
            throw new LindormException(ioe);
        }
        if (config.getBlobEndpoint() != null) {
            this.blobClient = LConnectionManager.getBlobClient(config);
        }
        if (!(success = this.lconnection.registerService(serviceName, this))) {
            throw new LindormException("Duplicate service name " + serviceName);
        }
        LindormClientConfig lconnectionConfig = this.lconnection.getConfig();
        Class<LindormBasicService> clazz = LindormBasicService.class;
        synchronized (LindormBasicService.class) {
            if (lconnectionConfig.get(timeOutKey) == null) {
                lconnectionConfig.setInt(timeOutKey, this.operationTimeout);
            }
            if (lconnectionConfig.get(glitchKey) == null) {
                lconnectionConfig.setInt(glitchKey, this.glitchTimeout);
            }
            // ** MonitorExit[var7_10] (shouldn't be in output)
            this.onConfigChange(lconnectionConfig);
            this.closed = false;
            return;
        }
    }

    public void checkOpen() throws LindormException {
        if (this.closed) {
            throw new LindormException("Service already closed");
        }
    }

    @Override
    public void onConfigChange(LindormClientConfig config) throws LindormException {
        this.config = config;
        String eagleeyeKey = ConfigUtil.createServiceConfKey(this.serviceName, "lindorm.client.eagleeye.enabled");
        this.eagleeyeEnabled = config.getBoolean(eagleeyeKey, config.getBoolean("lindorm.client.eagleeye.enabled", false));
        boolean bl = this.eagleeyeEnabled = this.eagleeyeEnabled || config.getBoolean(eagleeyeKey, config.getBoolean("lindorm.client.eagleeye.enabled", false));
        if (this.eagleeyeEnabled) {
            this.tracer = new EagleEyeTracer();
        }
        this.slowTraceThreshold = config.getLong("lindorm.client.slowtrace.threshold", 0L);
        String timeOutKey = ConfigUtil.createServiceConfKey(this.serviceName, "lindorm.client.timeout");
        this.operationTimeout = config.getInt(timeOutKey, config.getInt("lindorm.client.timeout", 120000));
        String glitchKey = ConfigUtil.createServiceConfKey(this.serviceName, "lindorm.rpc.glitchtime");
        this.glitchTimeout = config.getInt(glitchKey, config.getInt("lindorm.rpc.glitchtime", -1));
        String user = config.getUser();
        if (user != null) {
            String userTimeOutKey = ConfigUtil.createServiceConfKey(user, "lindorm.client.timeout");
            this.operationTimeout = config.getInt(userTimeOutKey, this.operationTimeout);
            String userGlitchKey = ConfigUtil.createServiceConfKey(user, "lindorm.rpc.glitchtime");
            this.glitchTimeout = config.getInt(userGlitchKey, this.glitchTimeout);
        }
        this.clientRetryIfQuotaExceeded = config.getBoolean("lindorm.client.retry.if.quota.exceeded", true);
        ClientEnvLogUtil.resetLoggerLevel(config);
        this.initCauseBy = config.getBoolean("lindorm.client.init.causeby", LindormClientConstants.LINDORM_CLIENT_INIT_CAUSEBY_DEFAULT);
        LOG.info((Object)("Service " + this.serviceName + "Configuration changed , timeout: " + this.operationTimeout + ", glitch " + this.glitchTimeout + ", eagleeye enabled " + this.eagleeyeEnabled + ", slow trace threshold " + this.slowTraceThreshold));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LConnection conn = this.lconnection;
        BlobClient client = this.blobClient;
        if (this.closed) {
            return;
        }
        LindormBasicService lindormBasicService = this;
        synchronized (lindormBasicService) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.lconnection = null;
            this.blobClient = null;
        }
        conn.unregisterService(this.serviceName);
        String timeOutKey = ConfigUtil.createServiceConfKey(this.serviceName, "lindorm.client.timeout");
        String glitchKey = ConfigUtil.createServiceConfKey(this.serviceName, "lindorm.rpc.glitchtime");
        Class<LindormBasicService> clazz = LindormBasicService.class;
        synchronized (LindormBasicService.class) {
            conn.getConfig().remove(timeOutKey);
            conn.getConfig().remove(glitchKey);
            // ** MonitorExit[var5_6] (shouldn't be in output)
            conn.close();
            LConnectionManager.deleteBlobClient(client);
            return;
        }
    }

    public void doAsUser(String user) {
        this.doAsUser = user;
    }

    public String getDoAsUser() {
        return this.doAsUser;
    }

    public LConnection getLConnection() {
        return this.lconnection;
    }

    public BlobClient getBlobClient() {
        return this.blobClient;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public int getGlitchTimeout() {
        return this.glitchTimeout;
    }

    public boolean isClientRetryIfQuotaExceeded() {
        return this.clientRetryIfQuotaExceeded;
    }

    @Override
    public void startOperation(String tableName, OperationContext.OperationType operationType) {
        if (this.tracer != null) {
            this.tracer.startOperation(tableName, operationType);
        }
    }

    @Override
    public void endOperationSuccessfully(String tableName, RetryingCaller caller) {
        if (this.tracer != null) {
            this.tracer.endOperationSuccessfully(tableName, caller);
        }
        this.traceReqeust(this.namespace, tableName, caller, false);
    }

    @Override
    public void endOperationExceptionally(String tableName, RetryingCaller caller, Throwable t) {
        if (this.tracer != null) {
            this.tracer.endOperationExceptionally(tableName, caller, t);
        }
        this.traceReqeust(this.namespace, tableName, caller, true);
    }

    @Override
    public Object startOperationAsync(String tableName, OperationContext.OperationType operationType) {
        if (this.tracer != null) {
            return this.tracer.startOperationAsync(tableName, operationType);
        }
        return null;
    }

    @Override
    public void endOperationAsyncSuccessfully(Object context, String tableName, RetryingCaller caller) {
        if (this.tracer != null && context != null) {
            this.tracer.endOperationAsyncSuccessfully(context, tableName, caller);
        }
        this.traceReqeust(this.namespace, tableName, caller, false);
    }

    @Override
    public void endOperationAsyncExceptionally(Object context, String tableName, RetryingCaller caller, Throwable t) {
        if (this.tracer != null && context != null) {
            this.tracer.endOperationAsyncExceptionally(context, tableName, caller, t);
        }
        this.traceReqeust(this.namespace, tableName, caller, true);
    }

    private void traceReqeust(String namespace, String tableName, RetryingCaller caller, boolean isError) {
        long spendTs = System.currentTimeMillis() - caller.getCreateTs();
        if (this.slowTraceThreshold != 0L && (isError || spendTs > this.slowTraceThreshold)) {
            SLOW_TRACE.warn("Slow request to namespace " + namespace + ", table " + tableName + ", time " + spendTs + ", trace " + caller.getTraceMessage());
        }
    }

    public boolean isInitCauseBy() {
        return this.initCauseBy;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }
}

