/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.command;

import com.alibaba.lindorm.client.core.command.CommandResult;
import com.alibaba.lindorm.client.core.command.GetConfCommand;
import com.alibaba.lindorm.client.core.command.GetMetricsCommand;
import com.alibaba.lindorm.client.core.command.UnKnownCommand;
import com.alibaba.lindorm.client.core.ipc.LConnection;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class Command
extends VersionedObjectWithAttributes {
    long commandID;
    long sendTime;

    public abstract Type getType();

    public long getID() {
        return this.commandID;
    }

    public void setID(long id) {
        this.commandID = id;
    }

    public long getSendTime() {
        return this.sendTime;
    }

    public void setSendTime(long sendTime) {
        this.sendTime = sendTime;
    }

    public abstract CommandResult run(LConnection var1);

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeVLong(out, this.commandID);
        WritableUtils.writeVLong(out, this.sendTime);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.commandID = WritableUtils.readVLong(in);
        this.sendTime = WritableUtils.readVLong(in);
    }

    public static Command parseCommandFromBytes(long commandID, int type, byte[] commandInBytes) throws IOException {
        Type commandType = Type.UNKNOWN;
        try {
            commandType = Type.codeToType(type);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        switch (commandType) {
            case GETCONF: {
                GetConfCommand getConfCommand = new GetConfCommand();
                WritableUtils.getWritable(commandInBytes, getConfCommand);
                return getConfCommand;
            }
            case GETMETRIC: {
                GetMetricsCommand getMetricsCommand = new GetMetricsCommand();
                WritableUtils.getWritable(commandInBytes, getMetricsCommand);
                return getMetricsCommand;
            }
        }
        return new UnKnownCommand(commandID, type);
    }

    @Override
    public String toString() {
        return "CommandID: " + this.commandID + " commandType: " + (Object)((Object)this.getType()) + " sendTime: " + this.sendTime + " ";
    }

    public static enum Type {
        UNKNOWN(0),
        MESSAGE(1),
        ERROR(2),
        GETCONF(64),
        GETMETRIC(65),
        GETTRACE(66);

        private int code;

        private Type(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static Type codeToType(int b) {
            for (Type d : Type.values()) {
                if (d.getCode() != b) continue;
                return d;
            }
            throw new RuntimeException("Unknown code " + b);
        }
    }
}

