/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.command;

import com.alibaba.lindorm.client.core.command.Command;
import com.alibaba.lindorm.client.core.command.CommandExecuteInfo;
import com.alibaba.lindorm.client.core.command.CommandResult;
import com.alibaba.lindorm.client.core.ipc.LConnection;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandExecutor
extends Thread {
    private static final Log LOG = LogFactory.getLog((String)CommandExecutor.class.getName());
    private static final AtomicLong COMMAND_EXECUTOR_ID = new AtomicLong();
    private LConnection lConnection;
    private LinkedBlockingQueue<CommandExecuteInfo> commandQueue;
    private volatile boolean isStopped = false;
    private int retyNum = 120;

    public CommandExecutor(LConnection lConnection, LinkedBlockingQueue<CommandExecuteInfo> commandQueue) {
        this.setName("ClientCommandExecutor:" + COMMAND_EXECUTOR_ID.incrementAndGet());
        this.lConnection = lConnection;
        this.commandQueue = commandQueue;
    }

    public void close() {
        this.isStopped = true;
        this.interrupt();
    }

    @Override
    public void run() {
        while (!this.isStopped) {
            CommandResult result;
            CommandExecuteInfo executeInfo = null;
            try {
                executeInfo = this.commandQueue.take();
                Command command = executeInfo.getCommand();
                result = command.run(this.lConnection);
                LOG.info((Object)("Finished execute command " + command + " with result " + result));
                if (result == null) continue;
                boolean isSent = false;
                for (int i = 0; i < this.retyNum; ++i) {
                    if (this.lConnection.getConfigUpdater().getCommandResult() == null) {
                        this.lConnection.getConfigUpdater().setCommandResult(result);
                        isSent = true;
                        break;
                    }
                    if (i > 0) {
                        this.lConnection.getConfigUpdater().updateNow();
                    }
                    Thread.sleep(1000L);
                }
                if (!isSent) {
                    LOG.debug((Object)("dropped command result " + result));
                    continue;
                }
                this.lConnection.getConfigUpdater().updateNow();
            }
            catch (InterruptedException ie) {
                LOG.debug((Object)"CommandExecutor is interrupted!");
                break;
            }
            catch (Throwable t) {
                if (executeInfo == null) continue;
                LOG.debug((Object)("Error happened when executing " + executeInfo), t);
                if (this.lConnection.getConfigUpdater().getCommandResult() != null) continue;
                result = new CommandResult(StringUtils.stringifyException(t), Command.Type.UNKNOWN, executeInfo.getCommandID());
                this.lConnection.getConfigUpdater().setCommandResult(result);
            }
        }
        LOG.info((Object)(this.getName() + " exits"));
    }
}

