/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.core.compile.ColumnSlot;
import com.alibaba.lindorm.client.core.compile.MultiCellColumnSlot;
import com.alibaba.lindorm.client.core.expression.ComparisonExpression;
import com.alibaba.lindorm.client.core.expression.ContainsExpression;
import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.expression.LikeExpression;
import com.alibaba.lindorm.client.core.expression.NotExistExpression;
import com.alibaba.lindorm.client.core.expression.NotLikeExpression;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.core.utils.Preconditions;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConjunctiveClause {
    private List<ColumnSlot> columnSlots;
    private List<Expression> expressions = new ArrayList<Expression>();

    public ConjunctiveClause(LColumn column, ComparisonExpression expression) throws IllegalDataException, IllegalRequestException {
        this.columnSlots = Collections.singletonList(ColumnSlot.create(column, expression));
    }

    public ConjunctiveClause(LColumn column, ContainsExpression expression) throws IllegalDataException {
        this.columnSlots = new ArrayList<ColumnSlot>();
        this.columnSlots.add(MultiCellColumnSlot.create(column, expression));
    }

    public ConjunctiveClause(LColumn column, NotExistExpression expression) {
        this.columnSlots = Collections.singletonList(ColumnSlot.create(column, expression));
    }

    public ConjunctiveClause(LColumn column, LikeExpression expression) throws LindormException {
        this.columnSlots = Collections.singletonList(ColumnSlot.create(column, expression));
    }

    public ConjunctiveClause(LColumn column, NotLikeExpression expression) throws LindormException {
        this.columnSlots = Collections.singletonList(ColumnSlot.create(column, expression));
    }

    public ConjunctiveClause(List<ColumnSlot> newColumnSlots) {
        this.columnSlots = newColumnSlots;
    }

    public ConjunctiveClause(List<ColumnSlot> newColumnSlots, List<Expression> expressions) {
        Preconditions.checkNotNull(expressions, "expressions should not be null");
        this.columnSlots = newColumnSlots;
        this.expressions = expressions;
    }

    public void andInPlace(ConjunctiveClause other) throws LindormException {
        this.columnSlots = this.mergeColumnSlots(other);
        this.expressions = ConjunctiveClause.mergeExpressions(this, other);
    }

    public ConjunctiveClause and(ConjunctiveClause other) throws LindormException {
        return new ConjunctiveClause(this.mergeColumnSlots(other), ConjunctiveClause.mergeExpressions(this, other));
    }

    private List<ColumnSlot> mergeColumnSlots(ConjunctiveClause other) throws LindormException {
        if (this.columnSlots == null || other.columnSlots == null) {
            return null;
        }
        int numColumns = this.columnSlots.size();
        int numOtherColumns = other.columnSlots.size();
        int i = 0;
        int j = 0;
        ArrayList<ColumnSlot> newColumnSlots = new ArrayList<ColumnSlot>(numColumns + numOtherColumns);
        while (i < numColumns || j < numOtherColumns) {
            if (j >= numOtherColumns) {
                newColumnSlots.add(this.columnSlots.get(i++));
                continue;
            }
            if (i >= numColumns) {
                newColumnSlots.add(other.columnSlots.get(j++));
                continue;
            }
            ColumnSlot columnSlot = this.columnSlots.get(i);
            ColumnSlot otherColumnSlot = other.columnSlots.get(j);
            int compare = CompilerUtils.compareColumnPosition(columnSlot.getColumn(), otherColumnSlot.getColumn());
            if (compare < 0) {
                newColumnSlots.add(columnSlot);
                ++i;
                continue;
            }
            if (compare > 0) {
                newColumnSlots.add(otherColumnSlot);
                ++j;
                continue;
            }
            ColumnSlot result = columnSlot.intersect(otherColumnSlot);
            result.setHBaseNumericTypeColumn(columnSlot.isHBaseNumericTypeColumn());
            if (!result.isEmpty()) {
                newColumnSlots.add(result);
                ++i;
                ++j;
                continue;
            }
            newColumnSlots = null;
            break;
        }
        return newColumnSlots;
    }

    private static List<Expression> mergeExpressions(ConjunctiveClause a, ConjunctiveClause b) {
        ArrayList<Expression> ret = new ArrayList<Expression>(a.getExpressions().size() + b.getExpressions().size());
        ret.addAll(a.getExpressions());
        ret.addAll(b.getExpressions());
        return ret;
    }

    public List<ColumnSlot> getColumnSlots() {
        return this.columnSlots;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public boolean isEmpty() {
        return !(this.columnSlots != null && !this.columnSlots.isEmpty() || this.expressions != null && !this.expressions.isEmpty());
    }

    public int hashCode() {
        if (this.columnSlots == null && this.expressions == null) {
            return 0;
        }
        int result = 1;
        for (ColumnSlot columnSlot : this.columnSlots) {
            result = result * 31 + columnSlot.hashCode();
        }
        for (Expression expression : this.expressions) {
            result = result * 31 + expression.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean ret;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConjunctiveClause)) {
            return false;
        }
        ConjunctiveClause other = (ConjunctiveClause)obj;
        boolean bl = this.columnSlots == null ? other.columnSlots == null : (ret = this.columnSlots.equals(other.columnSlots));
        if (!ret) {
            return false;
        }
        return this.expressions == null ? other.expressions == null : this.expressions.equals(other.expressions);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("(");
        boolean passTheFirst = false;
        for (ColumnSlot slot : this.columnSlots) {
            if (passTheFirst) {
                str.append(" and ");
            }
            str.append(slot.toString());
            passTheFirst = true;
        }
        for (Expression expression : this.expressions) {
            if (passTheFirst) {
                str.append(" and ");
            }
            str.append(expression.toString());
            passTheFirst = true;
        }
        str.append(")");
        return str.toString();
    }
}

