/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.core.compile.Interval;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;

public class HBaseNumericInterval
extends Interval {
    private final Pair<Interval, Interval> hbaseTypeInterval;
    private final boolean isSingleValue;
    public static final HBaseNumericInterval EVERYTHING_RANGE = new HBaseNumericInterval(Interval.EVERYTHING_RANGE, Interval.EVERYTHING_RANGE);
    public static final HBaseNumericInterval EMPTY_RANGE = new HBaseNumericInterval(Interval.EMPTY_RANGE, Interval.EMPTY_RANGE);

    private HBaseNumericInterval(Interval positiveInterval, Interval negativeInterval) {
        super(null, false, null, false);
        assert (positiveInterval != null && negativeInterval != null);
        this.isSingleValue = positiveInterval.isSingleValue() && negativeInterval.equals(Interval.EMPTY_RANGE) || positiveInterval.equals(Interval.EMPTY_RANGE) && negativeInterval.isSingleValue();
        this.hbaseTypeInterval = new Pair<Interval, Interval>(positiveInterval, negativeInterval);
    }

    private HBaseNumericInterval(Pair<Interval, Interval> interval) {
        super(null, false, null, false);
        assert (interval != null);
        this.isSingleValue = interval.getFirst() != null && interval.getFirst().isSingleValue() && interval.getSecond().equals(Interval.EMPTY_RANGE) || interval.getFirst() != null && interval.getFirst().equals(Interval.EMPTY_RANGE) && interval.getSecond().isSingleValue();
        this.hbaseTypeInterval = interval;
    }

    public static HBaseNumericInterval create(Interval positiveInterval, Interval negativeInterval) {
        return new HBaseNumericInterval(positiveInterval, negativeInterval);
    }

    public static HBaseNumericInterval create(Pair<Interval, Interval> interval) {
        return new HBaseNumericInterval(interval);
    }

    public Interval getPositiveInterval() {
        return this.hbaseTypeInterval.getFirst();
    }

    public Interval getNegativeInterval() {
        return this.hbaseTypeInterval.getSecond();
    }

    @Override
    public boolean isSingleValue() {
        return this.isSingleValue;
    }

    @Override
    public byte[] getSingleValue() {
        return this.hbaseTypeInterval.getFirst().equals(Interval.EMPTY_RANGE) ? this.hbaseTypeInterval.getSecond().getLower() : this.hbaseTypeInterval.getFirst().getLower();
    }

    @Override
    public HBaseNumericInterval intersect(Interval other, LColumn column) throws LindormException {
        assert (this.getPositiveInterval() != null && this.getNegativeInterval() != null);
        if (!(other instanceof HBaseNumericInterval)) {
            throw new IllegalRequestException("Not expected to reach here.");
        }
        HBaseNumericInterval otherInterval = (HBaseNumericInterval)other;
        Interval newPosInterval = this.getPositiveInterval().intersect(otherInterval.getPositiveInterval(), column);
        Interval newNegInterval = this.getNegativeInterval().intersect(otherInterval.getNegativeInterval(), column);
        return new HBaseNumericInterval(newPosInterval, newNegInterval);
    }

    @Override
    public boolean isOverlapped(Interval other, LColumn column) throws LindormException {
        return this.intersect(other, column) != EMPTY_RANGE;
    }

    @Override
    public Interval union(Interval other) throws RuntimeException {
        throw new RuntimeException("Not expected to reach here");
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 0;
            if (this.hbaseTypeInterval != null) {
                if (this.hbaseTypeInterval.getFirst() != null) {
                    result += this.hbaseTypeInterval.getFirst().hashCode();
                }
                if (this.hbaseTypeInterval.getSecond() != null) {
                    result += this.hbaseTypeInterval.getSecond().hashCode();
                }
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Interval)) {
            return false;
        }
        if (obj instanceof HBaseNumericInterval) {
            HBaseNumericInterval other = (HBaseNumericInterval)obj;
            return this.getPositiveInterval().equals(other.getPositiveInterval()) && this.getNegativeInterval().equals(other.getNegativeInterval());
        }
        if (obj.equals(Interval.EMPTY_RANGE)) {
            return this.equals(EMPTY_RANGE);
        }
        if (obj.equals(Interval.EVERYTHING_RANGE)) {
            return this.equals(EVERYTHING_RANGE);
        }
        throw new RuntimeException("Not expected to reach here");
    }

    @Override
    public String toString() {
        if (this == EMPTY_RANGE) {
            return "_NA_";
        }
        if (this.isSingleValue()) {
            return Bytes.toStringBinary(this.getSingleValue());
        }
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getPositiveInterval());
        str.append(", ");
        str.append(this.getNegativeInterval());
        str.append("]");
        return str.toString();
    }

    @Override
    public String toString(LColumn column) {
        if (this == EMPTY_RANGE) {
            return "_NA_";
        }
        if (this.isSingleValue()) {
            return Bytes.toStringBinary(this.getSingleValue());
        }
        StringBuilder str = new StringBuilder();
        str.append(" in ");
        try {
            if (this.hbaseTypeInterval.getFirst().isLowerInclusive()) {
                str.append("[");
            } else {
                str.append("(");
            }
            if (this.hbaseTypeInterval.getFirst().isLowerUnbound()) {
                str.append("*");
            } else {
                str.append(LDataType.toObject(column, this.hbaseTypeInterval.getFirst().getLower()));
            }
            str.append(" - ");
            if (this.hbaseTypeInterval.getFirst().isUpperUnbound()) {
                str.append("*");
            } else {
                str.append(LDataType.toObject(column, this.hbaseTypeInterval.getFirst().getUpper()));
            }
            if (this.hbaseTypeInterval.getFirst().isUpperInclusive()) {
                str.append("], ");
            } else {
                str.append("), ");
            }
            if (this.hbaseTypeInterval.getSecond().isLowerInclusive()) {
                str.append("[");
            } else {
                str.append("(");
            }
            if (this.hbaseTypeInterval.getSecond().isLowerUnbound()) {
                str.append("*");
            } else {
                str.append(LDataType.toObject(column, this.hbaseTypeInterval.getSecond().getLower()));
            }
            str.append(" - ");
            if (this.hbaseTypeInterval.getSecond().isUpperUnbound()) {
                str.append("*");
            } else {
                str.append(LDataType.toObject(column, this.hbaseTypeInterval.getSecond().getUpper()));
            }
            if (this.hbaseTypeInterval.getSecond().isUpperInclusive()) {
                str.append("]");
            } else {
                str.append(")");
            }
        }
        catch (IllegalDataException illegalDataException) {
            // empty catch block
        }
        return str.toString();
    }

    @Override
    public boolean contains(byte[] point) {
        return this.getPositiveInterval().contains(point) || this.getNegativeInterval().contains(point);
    }

    @Override
    public byte[] getLower() throws RuntimeException {
        throw new RuntimeException("Not expected to reach here");
    }

    @Override
    public byte[] getUpper() throws RuntimeException {
        throw new RuntimeException("Not expected to reach here");
    }

    @Override
    public boolean isLowerInclusive() throws RuntimeException {
        throw new RuntimeException("Not expected to reach here");
    }

    @Override
    public boolean isUpperInclusive() throws RuntimeException {
        throw new RuntimeException("Not expected to reach here");
    }

    @Override
    public boolean isLowerUnbound() throws RuntimeException {
        throw new RuntimeException("Not expected to reach here");
    }

    @Override
    public boolean isUpperUnbound() throws RuntimeException {
        throw new RuntimeException("Not expected to reach here");
    }
}

