/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.core.compile.ColumnSlot;
import com.alibaba.lindorm.client.core.compile.HBaseNumericInterval;
import com.alibaba.lindorm.client.core.compile.Interval;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.dml.ConditionFactory;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.DataType;
import java.util.SortedSet;
import java.util.TreeSet;

public class HBaseNumericTypeColumnSlotUtil {
    public static Pair<HBaseNumericInterval, SortedSet<ColumnSlot.Point>> createHBaseNumericalTypeInterval(LDataType dataType, byte[] value, ConditionFactory.CompareOp op) throws IllegalRequestException {
        assert (DataTypeUtils.isHBaseNumericType(dataType));
        if (HBaseNumericTypeColumnSlotUtil.isClosedRange(op)) {
            Pair<Interval, Interval> interval;
            String symbol = null;
            if (value != null) {
                symbol = Integer.toHexString(value[0] >>> 7 & 1);
            }
            if (dataType.getClientType() == DataType.HLONG || dataType.getClientType() == DataType.HSHORT || dataType.getClientType() == DataType.HINT) {
                interval = HBaseNumericTypeColumnSlotUtil.createIntegralNumericalInterval(dataType, symbol, value, op);
            } else if (dataType.getClientType() == DataType.HFLOAT || dataType.getClientType() == DataType.HDOUBLE) {
                interval = HBaseNumericTypeColumnSlotUtil.createFloatingNumericalInterval(dataType, symbol, value, op);
            } else {
                throw new IllegalRequestException("Not implement data type interval, current data type = " + dataType);
            }
            HBaseNumericInterval hBaseNumericInterval = interval == null ? null : HBaseNumericInterval.create(interval);
            return new Pair<HBaseNumericInterval, Object>(hBaseNumericInterval, null);
        }
        return HBaseNumericTypeColumnSlotUtil.createExclusions(value, op);
    }

    private static Pair<Interval, Interval> createIntegralNumericalInterval(LDataType dataType, String symbol, byte[] value, ConditionFactory.CompareOp op) {
        Pair<byte[], byte[]> boundValue = HBaseNumericTypeColumnSlotUtil.createBoundValue(dataType);
        byte[] minValue = boundValue.getFirst();
        byte[] maxValue = boundValue.getSecond();
        Interval postiveInterval = null;
        Interval negativeInterval = null;
        if (symbol != null && symbol.equals("1")) {
            switch (op) {
                case EQUAL: 
                case IS: {
                    negativeInterval = Interval.create(value, true, value, true);
                    postiveInterval = Interval.EMPTY_RANGE;
                    break;
                }
                case LESS: {
                    negativeInterval = Interval.create(minValue, true, value, false);
                    postiveInterval = Interval.EMPTY_RANGE;
                    break;
                }
                case LESS_OR_EQUAL: {
                    negativeInterval = Interval.create(minValue, true, value, true);
                    postiveInterval = Interval.EMPTY_RANGE;
                    break;
                }
                case GREATER: {
                    negativeInterval = Interval.create(value, false, Interval.UNBOUND, false);
                    postiveInterval = Interval.create(Interval.UNBOUND, false, maxValue, true);
                    break;
                }
                case GREATER_OR_EQUAL: {
                    negativeInterval = Interval.create(value, true, Interval.UNBOUND, false);
                    postiveInterval = Interval.create(Interval.UNBOUND, false, maxValue, true);
                    break;
                }
                default: {
                    throw new RuntimeException("UnKnown compare operation used in hbase data type, current CompareOp = " + (Object)((Object)op));
                }
            }
            return Pair.newPair(postiveInterval, negativeInterval);
        }
        if (symbol != null && symbol.equals("0")) {
            switch (op) {
                case EQUAL: 
                case IS: {
                    postiveInterval = Interval.create(value, true, value, true);
                    negativeInterval = Interval.EMPTY_RANGE;
                    break;
                }
                case LESS: {
                    postiveInterval = Interval.create(Interval.UNBOUND, false, value, false);
                    negativeInterval = Interval.create(minValue, true, Interval.UNBOUND, false);
                    break;
                }
                case LESS_OR_EQUAL: {
                    postiveInterval = Interval.create(Interval.UNBOUND, false, value, true);
                    negativeInterval = Interval.create(minValue, true, Interval.UNBOUND, false);
                    break;
                }
                case GREATER: {
                    postiveInterval = Interval.create(value, false, maxValue, true);
                    negativeInterval = Interval.EMPTY_RANGE;
                    break;
                }
                case GREATER_OR_EQUAL: {
                    postiveInterval = Interval.create(value, true, maxValue, true);
                    negativeInterval = Interval.EMPTY_RANGE;
                    break;
                }
                default: {
                    throw new RuntimeException("UnKnown compare operation used in hbase data type, current CompareOp = " + (Object)((Object)op));
                }
            }
            return Pair.newPair(postiveInterval, negativeInterval);
        }
        switch (op) {
            case IS: {
                postiveInterval = null;
                negativeInterval = null;
                break;
            }
            case EQUAL: 
            case LESS: 
            case LESS_OR_EQUAL: 
            case GREATER: 
            case GREATER_OR_EQUAL: {
                postiveInterval = Interval.EMPTY_RANGE;
                negativeInterval = Interval.EMPTY_RANGE;
                break;
            }
            default: {
                throw new RuntimeException("UnKnown compare operation used in hbase data type, current CompareOp = " + (Object)((Object)op));
            }
        }
        if (postiveInterval == null && negativeInterval == null) {
            return null;
        }
        return Pair.newPair(postiveInterval, negativeInterval);
    }

    private static Pair<Interval, Interval> createFloatingNumericalInterval(LDataType dataType, String symbol, byte[] value, ConditionFactory.CompareOp op) {
        Pair<byte[], byte[]> boundValue = HBaseNumericTypeColumnSlotUtil.createBoundValue(dataType);
        byte[] negativeZero = boundValue.getFirst();
        byte[] positiveMaxValue = boundValue.getSecond();
        Interval postiveInterval = null;
        Interval negativeInterval = null;
        if (symbol != null && symbol.equals("1")) {
            switch (op) {
                case EQUAL: 
                case IS: {
                    negativeInterval = HBaseNumericInterval.create(value, true, value, true);
                    postiveInterval = Interval.EMPTY_RANGE;
                    break;
                }
                case LESS: {
                    negativeInterval = Interval.create(value, false, Interval.UNBOUND, false);
                    postiveInterval = Interval.EMPTY_RANGE;
                    break;
                }
                case LESS_OR_EQUAL: {
                    negativeInterval = Interval.create(value, true, Interval.UNBOUND, false);
                    postiveInterval = Interval.EMPTY_RANGE;
                    break;
                }
                case GREATER: {
                    negativeInterval = Interval.create(negativeZero, true, value, false);
                    postiveInterval = Interval.create(Interval.UNBOUND, false, positiveMaxValue, true);
                    break;
                }
                case GREATER_OR_EQUAL: {
                    negativeInterval = Interval.create(negativeZero, true, value, true);
                    postiveInterval = Interval.create(Interval.UNBOUND, false, positiveMaxValue, true);
                    break;
                }
                default: {
                    throw new RuntimeException("UnKnown compare operation used in hbase data type, current CompareOp = " + (Object)((Object)op));
                }
            }
            return Pair.newPair(postiveInterval, negativeInterval);
        }
        if (symbol != null && symbol.equals("0")) {
            switch (op) {
                case EQUAL: 
                case IS: {
                    postiveInterval = HBaseNumericInterval.create(value, true, value, true);
                    negativeInterval = Interval.EMPTY_RANGE;
                    break;
                }
                case LESS: {
                    postiveInterval = Interval.create(Interval.UNBOUND, false, value, false);
                    negativeInterval = Interval.create(negativeZero, true, Interval.UNBOUND, false);
                    break;
                }
                case LESS_OR_EQUAL: {
                    postiveInterval = Interval.create(Interval.UNBOUND, false, value, true);
                    negativeInterval = Interval.create(negativeZero, true, Interval.UNBOUND, false);
                    break;
                }
                case GREATER: {
                    postiveInterval = Interval.create(value, false, positiveMaxValue, true);
                    negativeInterval = Interval.EMPTY_RANGE;
                    break;
                }
                case GREATER_OR_EQUAL: {
                    postiveInterval = Interval.create(value, true, positiveMaxValue, true);
                    negativeInterval = Interval.EMPTY_RANGE;
                    break;
                }
                default: {
                    throw new RuntimeException("UnKnown compare operation used in hbase data type, current CompareOp = " + (Object)((Object)op));
                }
            }
            return Pair.newPair(postiveInterval, negativeInterval);
        }
        switch (op) {
            case IS: {
                postiveInterval = null;
                negativeInterval = null;
                break;
            }
            case EQUAL: 
            case LESS: 
            case LESS_OR_EQUAL: 
            case GREATER: 
            case GREATER_OR_EQUAL: {
                postiveInterval = Interval.EMPTY_RANGE;
                negativeInterval = Interval.EMPTY_RANGE;
                break;
            }
            default: {
                throw new RuntimeException("UnKnown compare operation used in hbase data type, current CompareOp = " + (Object)((Object)op));
            }
        }
        if (postiveInterval == null && negativeInterval == null) {
            return null;
        }
        return Pair.newPair(postiveInterval, negativeInterval);
    }

    private static Pair<byte[], byte[]> createBoundValue(LDataType dataType) {
        int size = dataType.getByteSize();
        byte[] lower = new byte[size];
        byte[] upper = new byte[size];
        lower[0] = -128;
        upper[0] = 127;
        for (int i = 1; i < size; ++i) {
            lower[i] = 0;
            upper[i] = -1;
        }
        return new Pair<byte[], byte[]>(lower, upper);
    }

    private static Pair<HBaseNumericInterval, SortedSet<ColumnSlot.Point>> createExclusions(byte[] value, ConditionFactory.CompareOp op) throws IllegalRequestException {
        HBaseNumericInterval interval;
        TreeSet<ColumnSlot.Point> exclusions = null;
        switch (op) {
            case NOT_EQUAL: {
                interval = HBaseNumericInterval.EVERYTHING_RANGE;
                exclusions = new TreeSet<ColumnSlot.Point>();
                exclusions.add(new ColumnSlot.Point(value));
                break;
            }
            case IS_NOT: {
                interval = HBaseNumericInterval.EVERYTHING_RANGE;
                if (value == null) break;
                exclusions = new TreeSet();
                exclusions.add(new ColumnSlot.Point(value));
                break;
            }
            default: {
                throw new IllegalRequestException("UnKnown compare operation used in hbase data type, current CompareOp = " + (Object)((Object)op));
            }
        }
        return Pair.newPair(interval, exclusions);
    }

    private static boolean isClosedRange(ConditionFactory.CompareOp op) {
        return op == ConditionFactory.CompareOp.LESS || op == ConditionFactory.CompareOp.LESS_OR_EQUAL || op == ConditionFactory.CompareOp.EQUAL || op == ConditionFactory.CompareOp.GREATER || op == ConditionFactory.CompareOp.GREATER_OR_EQUAL || op == ConditionFactory.CompareOp.IS;
    }

    public static Pair<Interval, SortedSet<ColumnSlot.Point>> generateNewIntervalAndExclusions(Interval oldInterval, SortedSet<ColumnSlot.Point> oldExclusions, LColumn oldLColumn, LColumn newLColumn) throws LindormException {
        Pair<Interval, SortedSet<ColumnSlot.Point>> lNegativeInfo;
        assert (oldInterval instanceof HBaseNumericInterval);
        if (oldInterval.equals(HBaseNumericInterval.EMPTY_RANGE)) {
            return new Pair<Interval, Object>(Interval.EMPTY_RANGE, null);
        }
        Interval interval = null;
        SortedSet<ColumnSlot.Point> exclusions = null;
        HBaseNumericInterval hBaseNumericInterval = (HBaseNumericInterval)oldInterval;
        Pair<Interval, SortedSet<ColumnSlot.Point>> lPositiveInfo = CompilerUtils.generateNewIntervalAndExclusions(hBaseNumericInterval.getPositiveInterval(), oldExclusions, oldLColumn, newLColumn);
        DataType oldDataType = oldLColumn.getDataType().getClientType();
        if (oldDataType == DataType.HLONG || oldDataType == DataType.HSHORT || oldDataType == DataType.HINT) {
            lNegativeInfo = CompilerUtils.generateNewIntervalAndExclusions(hBaseNumericInterval.getNegativeInterval(), null, oldLColumn, newLColumn);
        } else if (oldDataType == DataType.HFLOAT || oldDataType == DataType.HDOUBLE) {
            Interval hNegative = hBaseNumericInterval.getNegativeInterval();
            if (!hNegative.equals(Interval.EMPTY_RANGE)) {
                Pair<byte[], byte[]> boundValue = HBaseNumericTypeColumnSlotUtil.createBoundValue(oldLColumn.getDataType());
                Interval tmpNegative = Bytes.equals(boundValue.getFirst(), hNegative.getLower()) ? Interval.create(hNegative.getUpper(), hNegative.isUpperInclusive(), Interval.UNBOUND, false) : Interval.create(hNegative.getUpper(), hNegative.isUpperInclusive(), hNegative.getLower(), hNegative.isLowerInclusive());
                lNegativeInfo = CompilerUtils.generateNewIntervalAndExclusions(tmpNegative, null, oldLColumn, newLColumn);
            } else {
                lNegativeInfo = CompilerUtils.generateNewIntervalAndExclusions(hNegative, null, oldLColumn, newLColumn);
            }
        } else {
            throw new IllegalRequestException("Not implement data type interval, current data type = " + (Object)((Object)oldDataType));
        }
        interval = lPositiveInfo.getFirst().equals(Interval.EMPTY_RANGE) ? lNegativeInfo.getFirst() : (lNegativeInfo.getFirst().equals(Interval.EMPTY_RANGE) ? lPositiveInfo.getFirst() : lPositiveInfo.getFirst().intersect(lNegativeInfo.getFirst(), newLColumn));
        exclusions = lPositiveInfo.getSecond();
        return new Pair<Interval, SortedSet<ColumnSlot.Point>>(interval, exclusions);
    }
}

