/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.ComparisonChain;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Interval {
    private final byte[] lower;
    private final boolean lowerInclusive;
    private final byte[] upper;
    private final boolean upperInclusive;
    private final boolean isSingleValue;
    protected int hashCode = 0;
    public static final byte[] UNBOUND = Bytes.EMPTY_BYTE_ARRAY;
    private static final byte[] DEGENERATE_KEY = new byte[]{1};
    public static final Interval EVERYTHING_RANGE = new Interval(UNBOUND, false, UNBOUND, false);
    public static final Interval EMPTY_RANGE = new Interval(DEGENERATE_KEY, false, DEGENERATE_KEY, false);
    public static final Comparator<Interval> COMPARATOR = new Comparator<Interval>(){

        @Override
        public int compare(Interval o1, Interval o2) {
            return ComparisonChain.start().compare(o2.isLowerUnbound(), o1.isLowerUnbound()).compare(o1.getLower(), o2.getLower(), Bytes.BYTES_COMPARATOR).compare(o2.isLowerInclusive(), o1.isLowerInclusive()).compare(o1.isUpperUnbound(), o2.isUpperUnbound()).compare(o1.getUpper(), o2.getUpper(), Bytes.BYTES_COMPARATOR).compare(o1.isUpperInclusive(), o2.isUpperInclusive()).result();
        }
    };

    public static Interval create(byte[] point) {
        return Interval.create(point, true, point, true);
    }

    public static Interval create(byte[] lower, byte[] upper) {
        return Interval.create(lower, true, upper, false);
    }

    public static Interval create(byte[] lower, boolean lowerInclusive, byte[] upper, boolean upperInclusive) {
        if (lower == null || upper == null) {
            return EMPTY_RANGE;
        }
        boolean unboundLower = false;
        boolean unboundUpper = false;
        if (lower.length == 0) {
            lower = UNBOUND;
            unboundLower = true;
            lowerInclusive = false;
        }
        if (upper.length == 0) {
            upper = UNBOUND;
            unboundUpper = true;
            upperInclusive = false;
        }
        if (unboundLower && unboundUpper) {
            return EVERYTHING_RANGE;
        }
        if (!unboundLower && !unboundUpper) {
            int cmp = Bytes.compareTo(lower, upper);
            if (cmp > 0) {
                return EMPTY_RANGE;
            }
            if (!(cmp != 0 || lowerInclusive && upperInclusive)) {
                return EMPTY_RANGE;
            }
        }
        return new Interval(lower, lowerInclusive, upper, upperInclusive);
    }

    protected Interval(byte[] lower, boolean lowerInclusive, byte[] upper, boolean upperInclusive) {
        this.lower = lower;
        this.lowerInclusive = lowerInclusive;
        this.upper = upper;
        this.upperInclusive = upperInclusive;
        boolean isNotUnBound = lower != UNBOUND && upper != UNBOUND;
        boolean isInclusive = lowerInclusive && upperInclusive;
        this.isSingleValue = isNotUnBound && isInclusive && Bytes.compareTo(lower, upper) == 0;
    }

    public byte[] getLower() {
        return this.lower;
    }

    public byte[] getUpper() {
        return this.upper;
    }

    public boolean isLowerInclusive() {
        return this.lowerInclusive;
    }

    public boolean isUpperInclusive() {
        return this.upperInclusive;
    }

    public boolean isLowerUnbound() {
        return this.lower == UNBOUND;
    }

    public boolean isUpperUnbound() {
        return this.upper == UNBOUND;
    }

    public boolean isSingleValue() {
        return this.isSingleValue;
    }

    public byte[] getSingleValue() {
        return this.lower;
    }

    public boolean isEmpty() {
        return this.equals(EMPTY_RANGE);
    }

    public Interval intersect(Interval other, LColumn column) throws LindormException {
        boolean newUpperInclusive;
        byte[] newUpper;
        int cmp;
        boolean newLowerInclusive;
        byte[] newLower;
        if (this == EMPTY_RANGE || other == EMPTY_RANGE) {
            return EMPTY_RANGE;
        }
        if (this == EVERYTHING_RANGE) {
            return other;
        }
        if (other == EVERYTHING_RANGE) {
            return this;
        }
        if (this.isLowerUnbound()) {
            newLower = other.lower;
            newLowerInclusive = other.lowerInclusive;
        } else if (other.isLowerUnbound()) {
            newLower = this.lower;
            newLowerInclusive = this.lowerInclusive;
        } else {
            cmp = Bytes.compareTo(this.lower, other.lower);
            if (cmp == 0) {
                newLower = this.lower;
                newLowerInclusive = this.lowerInclusive && other.lowerInclusive;
            } else if (cmp > 0) {
                newLower = this.lower;
                newLowerInclusive = this.lowerInclusive;
            } else {
                newLower = other.lower;
                newLowerInclusive = other.lowerInclusive;
            }
        }
        if (this.isUpperUnbound()) {
            newUpper = other.upper;
            newUpperInclusive = other.upperInclusive;
        } else if (other.isUpperUnbound()) {
            newUpper = this.upper;
            newUpperInclusive = this.upperInclusive;
        } else {
            cmp = Bytes.compareTo(this.upper, other.upper);
            if (cmp == 0) {
                newUpper = this.upper;
                newUpperInclusive = this.upperInclusive && other.upperInclusive;
            } else if (cmp > 0) {
                newUpper = other.upper;
                newUpperInclusive = other.upperInclusive;
            } else {
                newUpper = this.upper;
                newUpperInclusive = this.upperInclusive;
            }
        }
        if (column != null && SchemaUtils.isSaltPkOption(column.getPkOption()) && !Bytes.equals(newLower, newUpper)) {
            throw new LindormException("Do not support scan for salted table");
        }
        return Interval.create(newLower, newLowerInclusive, newUpper, newUpperInclusive);
    }

    public boolean isOverlapped(Interval other, LColumn column) throws LindormException {
        return this.intersect(other, column) != EMPTY_RANGE;
    }

    public Interval union(Interval other) {
        boolean newUpperInclusive;
        byte[] newUpper;
        int cmp;
        boolean newLowerInclusive;
        byte[] newLower;
        if (other == EMPTY_RANGE) {
            return this;
        }
        if (this == EMPTY_RANGE) {
            return other;
        }
        if (other == EVERYTHING_RANGE || this == EVERYTHING_RANGE) {
            return EVERYTHING_RANGE;
        }
        if (this.isLowerUnbound() || other.isLowerUnbound()) {
            newLower = UNBOUND;
            newLowerInclusive = false;
        } else {
            cmp = Bytes.compareTo(this.lower, other.lower);
            if (cmp < 0) {
                newLower = this.lower;
                newLowerInclusive = this.lowerInclusive;
            } else if (cmp > 0) {
                newLower = other.lower;
                newLowerInclusive = other.lowerInclusive;
            } else {
                newLower = this.lower;
                boolean bl = newLowerInclusive = this.lowerInclusive || other.lowerInclusive;
            }
        }
        if (this.isUpperUnbound() || other.isUpperUnbound()) {
            newUpper = UNBOUND;
            newUpperInclusive = false;
        } else {
            cmp = Bytes.compareTo(this.upper, other.upper);
            if (cmp < 0) {
                newUpper = other.upper;
                newUpperInclusive = other.upperInclusive;
            } else if (cmp > 0) {
                newUpper = this.upper;
                newUpperInclusive = this.upperInclusive;
            } else {
                newUpper = this.upper;
                newUpperInclusive = this.upperInclusive || other.upperInclusive;
            }
        }
        return Interval.create(newLower, newLowerInclusive, newUpper, newUpperInclusive);
    }

    public static List<Interval> intersect(List<Interval> lhs, List<Interval> rhs, LColumn column) throws LindormException {
        if (lhs.size() == 1 && rhs.size() == 1) {
            return CollectionUtils.newArrayList(lhs.get(0).intersect(rhs.get(0), column));
        }
        ArrayList<Interval> tmp = CollectionUtils.newArrayListWithCapacity(lhs.size());
        for (Interval i1 : lhs) {
            for (Interval i2 : rhs) {
                Interval i = i1.intersect(i2, column);
                if (i == EMPTY_RANGE) continue;
                tmp.add(i);
            }
        }
        if (tmp.size() == 0) {
            return Collections.singletonList(EMPTY_RANGE);
        }
        Collections.sort(tmp, COMPARATOR);
        ArrayList<Interval> tmp2 = CollectionUtils.newArrayListWithCapacity(tmp.size());
        Interval interval = (Interval)tmp.get(0);
        for (int i = 1; i < tmp.size(); ++i) {
            Interval i2;
            i2 = interval.intersect((Interval)tmp.get(i), column);
            if (i2 == EMPTY_RANGE) {
                tmp2.add(interval);
                interval = (Interval)tmp.get(i);
                continue;
            }
            interval = i2;
        }
        tmp2.add(interval);
        return tmp2;
    }

    public static List<Interval> union(List<Interval> lhs, List<Interval> rhs, LColumn column) throws LindormException {
        ArrayList<Interval> origin = CollectionUtils.newArrayListWithCapacity(lhs.size() + rhs.size());
        origin.addAll(lhs);
        origin.addAll(rhs);
        ArrayList<Interval> tmp = CollectionUtils.newArrayList();
        for (Interval i : origin) {
            if (i == EMPTY_RANGE) continue;
            if (i == EVERYTHING_RANGE) {
                return CollectionUtils.newArrayList(EVERYTHING_RANGE);
            }
            tmp.add(i);
        }
        if (tmp.size() == 1) {
            return tmp;
        }
        if (tmp.size() == 0) {
            return Collections.singletonList(EMPTY_RANGE);
        }
        Collections.sort(tmp, COMPARATOR);
        ArrayList<Interval> tmp2 = CollectionUtils.newArrayListWithCapacity(tmp.size());
        Interval curr = (Interval)tmp.get(0);
        for (int i = 1; i < tmp.size(); ++i) {
            Interval other = (Interval)tmp.get(i);
            if (curr.isOverlapped(other, column)) {
                curr = curr.union(other);
                continue;
            }
            tmp2.add(curr);
            curr = other;
        }
        tmp2.add(curr);
        ArrayList<Interval> tmp3 = CollectionUtils.newArrayListWithCapacity(origin.size());
        curr = (Interval)tmp2.get(0);
        for (int i = 1; i < tmp2.size(); ++i) {
            Interval other = (Interval)tmp2.get(i);
            assert (!curr.isUpperUnbound());
            assert (!other.isLowerUnbound());
            if (curr.isUpperInclusive() != other.isLowerInclusive() && Bytes.equals(curr.upper, other.lower)) {
                curr = Interval.create(curr.lower, curr.isLowerInclusive(), other.upper, other.isUpperInclusive());
                continue;
            }
            tmp3.add(curr);
            curr = other;
        }
        tmp3.add(curr);
        return tmp3;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.lower);
            if (this.lower != null) {
                result = 31 * result + (this.lowerInclusive ? 1231 : 1237);
            }
            result = 31 * result + Arrays.hashCode(this.upper);
            if (this.upper != null) {
                result = 31 * result + (this.upperInclusive ? 1231 : 1237);
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Interval)) {
            return false;
        }
        Interval other = (Interval)obj;
        return Bytes.compareTo(this.lower, other.lower) == 0 && this.lowerInclusive == other.lowerInclusive && Bytes.compareTo(this.upper, other.upper) == 0 && this.upperInclusive == other.upperInclusive;
    }

    public String toString() {
        if (this == EMPTY_RANGE) {
            return "_NA_";
        }
        if (this.isSingleValue()) {
            return Bytes.toStringBinary(this.lower);
        }
        StringBuilder str = new StringBuilder();
        if (this.lowerInclusive) {
            str.append("[");
        } else {
            str.append("(");
        }
        if (this.isLowerUnbound()) {
            str.append("*");
        } else {
            str.append(Bytes.toStringBinary(this.lower));
        }
        str.append(" - ");
        if (this.isUpperUnbound()) {
            str.append("*");
        } else {
            str.append(Bytes.toStringBinary(this.upper));
        }
        if (this.upperInclusive) {
            str.append("]");
        } else {
            str.append(")");
        }
        return str.toString();
    }

    public String toString(LColumn column) {
        if (this == EMPTY_RANGE) {
            return "_NA_";
        }
        if (this.isSingleValue()) {
            return Bytes.toStringBinary(this.lower);
        }
        StringBuilder str = new StringBuilder();
        try {
            if (this.isLowerInclusive()) {
                str.append("[");
            } else {
                str.append("(");
            }
            if (this.isLowerUnbound()) {
                str.append("*");
            } else {
                str.append(LDataType.toObject(column, this.getLower()));
            }
            str.append(" - ");
            if (this.isUpperUnbound()) {
                str.append("*");
            } else {
                str.append(LDataType.toObject(column, this.getUpper()));
            }
            if (this.isUpperInclusive()) {
                str.append("]");
            } else {
                str.append(")");
            }
        }
        catch (IllegalDataException illegalDataException) {
            // empty catch block
        }
        return str.toString();
    }

    public boolean contains(byte[] point) {
        if (Bytes.compareTo(point, UNBOUND) == 0 || this.equals(EMPTY_RANGE)) {
            return false;
        }
        if (this.equals(EVERYTHING_RANGE)) {
            return true;
        }
        int compareLower = Bytes.compareTo(this.lower, point);
        int compareUpper = Bytes.compareTo(point, this.upper);
        return (Bytes.compareTo(this.lower, UNBOUND) == 0 || compareLower < 0 || compareLower == 0 && this.lowerInclusive) && (Bytes.compareTo(this.upper, UNBOUND) == 0 || compareUpper < 0 || compareUpper == 0 && this.upperInclusive);
    }
}

