/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.core.compile.Interval;
import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class KeySlot {
    private int pkPosition;
    private boolean isSpan;
    private LColumn column;
    private Set<Expression> expressions;
    private List<Interval> ranges;

    public KeySlot(LColumn column, List<Interval> ranges, Set<Expression> expressions) {
        assert (ranges != null);
        assert (!ranges.isEmpty());
        this.column = column;
        if (column != null) {
            this.pkPosition = column.getPosition();
            this.isSpan = false;
        } else {
            this.pkPosition = 0;
            this.isSpan = true;
        }
        this.ranges = ranges;
        this.expressions = expressions;
    }

    public KeySlot(Interval range, Set<Expression> expressions) {
        this(null, CollectionUtils.newArrayList(range), expressions);
    }

    public LColumn getColumn() {
        return this.column;
    }

    public int getPkPosition() {
        return this.pkPosition;
    }

    public boolean isSpan() {
        return this.isSpan;
    }

    public Set<Expression> getExpressions() {
        return this.expressions;
    }

    public List<Interval> getIntervals() {
        return this.ranges;
    }

    public static KeySlot intersect(KeySlot ks1, KeySlot ks2) throws LindormException {
        assert (ks1.pkPosition == ks2.pkPosition);
        assert (ks1.isSpan == ks2.isSpan);
        assert (!ks1.isSpan);
        List<Interval> results = Interval.intersect(ks1.getIntervals(), ks2.getIntervals(), ks1.column);
        Set<Expression> expressions = ks1.getExpressions();
        expressions.addAll(ks2.expressions);
        return new KeySlot(ks1.getColumn(), results, expressions);
    }

    public static KeySlot union(KeySlot ks1, KeySlot ks2) throws LindormException {
        assert (ks1.pkPosition == ks2.pkPosition);
        assert (ks1.isSpan == ks2.isSpan);
        List<Interval> results = Interval.union(ks1.getIntervals(), ks2.getIntervals(), ks1.column);
        Set<Expression> expressions = ks1.getExpressions();
        expressions.addAll(ks2.expressions);
        return new KeySlot(ks1.getColumn(), results, expressions);
    }

    public static KeySlot tryCreateSpan(KeySlot[] slots) {
        int numberOfValidSlots = 0;
        boolean allSingleValueInterval = true;
        for (KeySlot ks : slots) {
            if (ks == null) break;
            ++numberOfValidSlots;
            List<Interval> itvls = ks.getIntervals();
            if (itvls != null && itvls.size() == 1 && itvls.get(0).isSingleValue()) continue;
            allSingleValueInterval = false;
            break;
        }
        KeySlot ret = null;
        if (numberOfValidSlots == slots.length && allSingleValueInterval) {
            HashSet<Expression> exprs = CollectionUtils.newHashSetWithExpectedSize(slots.length);
            Interval[] toMerge = new Interval[slots.length];
            int keyLength = 0;
            for (int i = 0; i < slots.length; ++i) {
                Interval v;
                KeySlot ks = slots[i];
                exprs.addAll(ks.getExpressions());
                toMerge[i] = v = ks.getIntervals().get(0);
                keyLength += v.getLower().length;
            }
            byte[] key = new byte[keyLength];
            int offset = 0;
            for (Interval itvl : toMerge) {
                System.arraycopy(itvl.getLower(), 0, key, offset, itvl.getLower().length);
                offset += itvl.getLower().length;
            }
            ret = new KeySlot(Interval.create(key), exprs);
        }
        return ret;
    }
}

