/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.core.compile.ColumnSlot;
import com.alibaba.lindorm.client.core.expression.ContainsExpression;
import com.alibaba.lindorm.client.core.expression.ContainsKeyExpression;
import com.alibaba.lindorm.client.core.expression.ContainsValueExpression;
import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.types.LCollectionType;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.dml.ConditionFactory;
import com.alibaba.lindorm.client.dml.ConditionList;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import java.util.HashSet;
import java.util.Set;

public class MultiCellColumnSlot
extends ColumnSlot {
    final Set containsValues;
    final Set containsKeys;

    public MultiCellColumnSlot(LColumn column, Set containsValues, Set containsKeys) {
        super(column, null, null);
        this.containsKeys = containsKeys;
        this.containsValues = containsValues;
    }

    public static MultiCellColumnSlot create(LColumn column, ContainsExpression expression) {
        Set values = expression.getValues();
        if (expression instanceof ContainsValueExpression) {
            return new MultiCellColumnSlot(column, values, null);
        }
        return new MultiCellColumnSlot(column, null, values);
    }

    @Override
    public ColumnSlot intersect(ColumnSlot otherColumnSlot) {
        assert (otherColumnSlot instanceof MultiCellColumnSlot);
        MultiCellColumnSlot slot2 = (MultiCellColumnSlot)otherColumnSlot;
        Set newContainsKeys = this.intersectContainsKeys(slot2);
        Set<byte[]> newContainsValues = this.intersectContainsValues(slot2);
        return new MultiCellColumnSlot(this.column, newContainsValues, newContainsKeys);
    }

    @Override
    public Expression toExpression() throws IllegalRequestException {
        ConditionList andExpression = ConditionFactory.and();
        if (this.containsValues != null) {
            andExpression.add(new ContainsValueExpression(this.column, this.containsValues));
        }
        if (this.containsKeys != null) {
            andExpression.add(new ContainsKeyExpression(this.column, this.containsKeys));
        }
        return andExpression.getConditions().size() > 1 ? andExpression : andExpression.getConditions().get(0);
    }

    @Override
    public boolean isNullValue() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.containsKeys != null) {
            builder.append(this.containsKeyString());
        }
        if (this.containsValues != null) {
            if (this.containsKeys != null) {
                builder.append(" and ");
            }
            builder.append(this.containsValueString());
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiCellColumnSlot that = (MultiCellColumnSlot)o;
        if (this.containsValues != null ? !this.containsValues.equals(that.containsValues) : that.containsValues != null) {
            return false;
        }
        return this.containsKeys != null ? this.containsKeys.equals(that.containsKeys) : that.containsKeys == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.containsValues != null ? this.containsValues.hashCode() : 0);
        result = 31 * result + (this.containsKeys != null ? this.containsKeys.hashCode() : 0);
        return result;
    }

    private Set<byte[]> intersectContainsValues(MultiCellColumnSlot otherColumnSlot) {
        HashSet<Object> result;
        if (this.containsValues == null && otherColumnSlot.containsValues == null) {
            result = null;
        } else if (this.containsValues == null) {
            result = new HashSet<byte[]>();
            result.addAll(otherColumnSlot.containsValues);
        } else if (otherColumnSlot.containsValues == null) {
            result = new HashSet();
            result.addAll(this.containsValues);
        } else {
            result = new HashSet();
            result.addAll(this.containsValues);
            result.addAll(otherColumnSlot.containsValues);
        }
        return result;
    }

    private Set intersectContainsKeys(MultiCellColumnSlot otherColumnSlot) {
        HashSet result;
        if (this.containsKeys == null && otherColumnSlot.containsKeys == null) {
            result = null;
        } else if (this.containsKeys == null) {
            result = new HashSet();
            result.addAll(otherColumnSlot.containsKeys);
        } else if (otherColumnSlot.containsKeys == null) {
            result = new HashSet();
            result.addAll(this.containsKeys);
        } else {
            result = new HashSet();
            result.addAll(this.containsKeys);
            result.addAll(otherColumnSlot.containsKeys);
        }
        return result;
    }

    private String containsValueString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(Bytes.toString(this.column.getColumnName()));
        builder.append(" contains value {");
        LDataType valueLDataType = ((LCollectionType)this.column.getDataType()).getValueType();
        for (Object obj : this.containsValues) {
            if (valueLDataType instanceof LCollectionType) {
                builder.append(DataTypeUtils.valueToString(((LCollectionType)valueLDataType).getCollectionDataType(), obj));
                continue;
            }
            builder.append(DataTypeUtils.valueToString(valueLDataType.getClientType(), obj));
        }
        builder.append("}");
        builder.append(")");
        return builder.toString();
    }

    private String containsKeyString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(Bytes.toString(this.column.getColumnName()));
        builder.append(" contains key {");
        LDataType keyLDataType = ((LCollectionType)this.column.getDataType()).getKeyType();
        for (Object obj : this.containsKeys) {
            if (keyLDataType instanceof LCollectionType) {
                builder.append(DataTypeUtils.valueToString(((LCollectionType)keyLDataType).getCollectionDataType(), obj));
                continue;
            }
            builder.append(DataTypeUtils.valueToString(keyLDataType.getClientType(), obj));
        }
        builder.append("}");
        builder.append(")");
        return builder.toString();
    }
}

