/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.core.compile.ColumnSlot;
import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import java.util.ArrayList;
import java.util.List;

public class QueryFilterInfo {
    private List<ColumnSlot> columnSlots;
    private List<Expression> expressions = new ArrayList<Expression>();
    private int hashCode;

    private QueryFilterInfo(List<ColumnSlot> columnSlots) {
        this.columnSlots = new ArrayList<ColumnSlot>(columnSlots);
    }

    private QueryFilterInfo(List<ColumnSlot> columnSlots, int start) {
        this.columnSlots = new ArrayList<ColumnSlot>(columnSlots.size() - start);
        for (int i = start; i < columnSlots.size(); ++i) {
            this.columnSlots.add(columnSlots.get(i));
        }
    }

    public static QueryFilterInfo create(List<ColumnSlot> columnSlots) {
        if (columnSlots == null) {
            return null;
        }
        QueryFilterInfo.checkSaltedRange(columnSlots, 0);
        return new QueryFilterInfo(columnSlots);
    }

    public static QueryFilterInfo create(List<ColumnSlot> columnSlots, List<Expression> expressions) {
        return QueryFilterInfo.create(columnSlots, 0, expressions);
    }

    private static void checkSaltedRange(List<ColumnSlot> columnSlots, int start) {
        for (int i = start; i < columnSlots.size(); ++i) {
            ColumnSlot columnSlot = columnSlots.get(i);
            if (!SchemaUtils.isSaltPkOption(columnSlot.getColumn().getPkOption()) || columnSlot.isNullValue() || columnSlot.getInterval().isSingleValue()) continue;
            throw new RuntimeException("Do not support scan for salted table.");
        }
    }

    public static QueryFilterInfo create(List<ColumnSlot> columnSlots, int start, List<Expression> expressions) {
        if (!(columnSlots != null && start < columnSlots.size() || expressions != null && !expressions.isEmpty())) {
            return null;
        }
        QueryFilterInfo.checkSaltedRange(columnSlots, start);
        QueryFilterInfo queryFilterInfo = new QueryFilterInfo(columnSlots, start);
        queryFilterInfo.setExpressions(expressions);
        return queryFilterInfo;
    }

    public List<ColumnSlot> getColumnSlots() {
        return this.columnSlots;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<Expression> expressions) {
        this.expressions = expressions;
    }

    public int hashCode() {
        if (this.hashCode == 0 && (this.columnSlots != null || this.expressions != null)) {
            int result = 1;
            for (ColumnSlot columnSlot : this.columnSlots) {
                result = 31 * result + columnSlot.hashCode();
            }
            for (Expression expression : this.expressions) {
                result = 31 * result + expression.hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        boolean ret;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QueryFilterInfo)) {
            return false;
        }
        QueryFilterInfo other = (QueryFilterInfo)obj;
        boolean bl = this.columnSlots == null ? other.columnSlots == null : (ret = this.columnSlots.equals(other.columnSlots));
        if (!ret) {
            return false;
        }
        return this.expressions == null ? other.expressions == null : this.expressions.equals(other.expressions);
    }

    public String toString() {
        int i;
        if ((this.columnSlots == null || this.columnSlots.isEmpty()) && (this.expressions == null || this.expressions.isEmpty())) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        boolean hasColumnSlot = false;
        for (i = 0; i < this.columnSlots.size(); ++i) {
            if (i != 0) {
                builder.append(" AND ");
            }
            builder.append(this.columnSlots.get(i));
            hasColumnSlot = true;
        }
        for (i = 0; i < this.expressions.size(); ++i) {
            if (hasColumnSlot || i != 0) {
                builder.append(" AND ");
            }
            builder.append(this.expressions.get(i));
        }
        return builder.toString();
    }
}

