/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.ColumnValue;
import com.alibaba.lindorm.client.dml.Row;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.Map;

public abstract class RowVisitor<R, C> {
    protected ColumnValueVisitor<R, C> defaultVisitor;
    protected Map<ColumnKey, ColumnValueVisitor<R, C>> visitorMap;

    protected RowVisitor() {
        this.defaultVisitor = new ColumnValueVisitor<R, C>(){

            @Override
            public void handleColumnValue(ColumnValue cv, R result, C context) {
            }
        };
    }

    protected RowVisitor(ColumnValueVisitor<R, C> defaultVisitor, Map<ColumnKey, ColumnValueVisitor<R, C>> visitorMap) {
        this.defaultVisitor = defaultVisitor;
        this.visitorMap = visitorMap;
    }

    public R visit(Row r, C context) throws LindormException {
        R result = this.createResult(context);
        for (ColumnValue cv : r.getColumnValues()) {
            ColumnValueVisitor<R, C> h = this.visitorMap.get(cv.getColumnKey());
            if (h != null) {
                h.handleColumnValue(cv, result, context);
                continue;
            }
            this.defaultVisitor.handleColumnValue(cv, result, context);
        }
        return result;
    }

    protected abstract R createResult(C var1);

    public static interface ColumnValueVisitor<R, C> {
        public void handleColumnValue(ColumnValue var1, R var2, C var3) throws LindormException;
    }
}

