/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.core.compile.BaseExpressionVisitor;
import com.alibaba.lindorm.client.core.compile.ColumnSlot;
import com.alibaba.lindorm.client.core.compile.ConjunctiveClause;
import com.alibaba.lindorm.client.core.compile.DisjunctiveNormalForm;
import com.alibaba.lindorm.client.core.expression.AndExpression;
import com.alibaba.lindorm.client.core.expression.ComparisonExpression;
import com.alibaba.lindorm.client.core.expression.ComparisonExpressionV2;
import com.alibaba.lindorm.client.core.expression.ComparisonExpressionV3;
import com.alibaba.lindorm.client.core.expression.ContainsExpression;
import com.alibaba.lindorm.client.core.expression.ExistExpression;
import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.expression.FunctionCall;
import com.alibaba.lindorm.client.core.expression.Identifier;
import com.alibaba.lindorm.client.core.expression.InExpression;
import com.alibaba.lindorm.client.core.expression.LikeExpression;
import com.alibaba.lindorm.client.core.expression.Literal;
import com.alibaba.lindorm.client.core.expression.NotExistExpression;
import com.alibaba.lindorm.client.core.expression.NotInExpression;
import com.alibaba.lindorm.client.core.expression.NotLikeExpression;
import com.alibaba.lindorm.client.core.expression.OrExpression;
import com.alibaba.lindorm.client.core.expression.RowComparisonExpression;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.types.LBoolean;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.ColumnValue;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.ConditionFactory;
import com.alibaba.lindorm.client.dml.ConditionList;
import com.alibaba.lindorm.client.dml.Row;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.DataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TransformIntoDNFVisitor
extends BaseExpressionVisitor<DisjunctiveNormalForm> {
    protected final TableMeta table;

    public TransformIntoDNFVisitor(TableMeta table) {
        this.table = table;
    }

    @Override
    public DisjunctiveNormalForm visitLeave(AndExpression node, List<DisjunctiveNormalForm> logicalExpressionsInChildren) throws LindormException {
        DisjunctiveNormalForm logicalExpression = new DisjunctiveNormalForm();
        for (DisjunctiveNormalForm expression : logicalExpressionsInChildren) {
            logicalExpression.and(expression);
        }
        return logicalExpression;
    }

    @Override
    public DisjunctiveNormalForm visitLeave(OrExpression node, List<DisjunctiveNormalForm> logicalExpressionsInChildren) throws LindormException {
        DisjunctiveNormalForm logicalExpression = new DisjunctiveNormalForm();
        for (DisjunctiveNormalForm expression : logicalExpressionsInChildren) {
            logicalExpression.or(expression);
        }
        return logicalExpression;
    }

    @Override
    public DisjunctiveNormalForm visit(ContainsExpression node) throws LindormException {
        LColumn column = this.table.resolveColumn(node.getColumnKey());
        if (!column.isCollectionType()) {
            throw new IllegalRequestException("contains expression only works with collection type column, current column type: " + (Object)((Object)column.getDataType().getClientType()));
        }
        if (!node.getType().equals(column.getDataType())) {
            throw new IllegalRequestException(String.format("type missmatch. column type: %s, provided type: %s", column.getDataType(), node.getType()));
        }
        return new DisjunctiveNormalForm(column, node);
    }

    @Override
    public DisjunctiveNormalForm visit(ComparisonExpression node) throws LindormException {
        LColumn column = this.table.resolveColumn(node.getColumnKey(), node.getDataType());
        if (column.isFunctionColumn()) {
            throw new IllegalRequestException("Function column " + column.getColumnKey() + " should not been used in condition directly");
        }
        return new DisjunctiveNormalForm(column, node);
    }

    @Override
    public DisjunctiveNormalForm visit(ComparisonExpressionV3 node) throws LindormException {
        if (node.getLeft() instanceof Identifier && node.getRight() instanceof Literal) {
            Identifier identifier = (Identifier)node.getLeft();
            Literal literal = (Literal)node.getRight();
            ColumnKey ck = identifier.toColumnKey();
            ComparisonExpression newNode = new ComparisonExpression(ck.getFamily(), ck.getQualifier(), node.getOp(), literal.getValue());
            return this.visit(newNode);
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add(node);
        ArrayList<ConjunctiveClause> list = new ArrayList<ConjunctiveClause>();
        list.add(new ConjunctiveClause(Collections.<ColumnSlot>emptyList(), expressions));
        return new DisjunctiveNormalForm(list);
    }

    @Override
    public DisjunctiveNormalForm visit(FunctionCall node) throws LindormException {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add(node);
        ArrayList<ConjunctiveClause> list = new ArrayList<ConjunctiveClause>();
        list.add(new ConjunctiveClause(Collections.<ColumnSlot>emptyList(), expressions));
        return new DisjunctiveNormalForm(list);
    }

    @Override
    public DisjunctiveNormalForm visit(Identifier node) throws LindormException {
        LColumn column = this.table.resolveColumn(node.toColumnKey());
        if (column.getDataType() != LBoolean.INSTANCE) {
            throw new IllegalRequestException("expect boolean column type as condition, actual: " + (Object)((Object)column.getDataType().getClientType()));
        }
        node.setColumn(column);
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add(node);
        ArrayList<ConjunctiveClause> list = new ArrayList<ConjunctiveClause>();
        list.add(new ConjunctiveClause(Collections.<ColumnSlot>emptyList(), expressions));
        return new DisjunctiveNormalForm(list);
    }

    @Override
    public DisjunctiveNormalForm visit(RowComparisonExpression node) throws LindormException {
        this.validateRow(node.getRow());
        boolean includeRow = false;
        ConditionFactory.CompareOp op = node.getOp();
        switch (op) {
            case LESS_OR_EQUAL: {
                includeRow = true;
            }
            case LESS: {
                Condition expression = this.generateMultipleConditions(node.getRow().getColumnValues(), ConditionFactory.CompareOp.LESS, includeRow);
                return expression.accept(this);
            }
            case EQUAL: 
            case NOT_EQUAL: {
                Condition expression = this.generateSingleCondition(node.getRow().getColumnValues(), op);
                return expression.accept(this);
            }
            case GREATER_OR_EQUAL: {
                includeRow = true;
            }
            case GREATER: {
                Condition expression = this.generateMultipleConditions(node.getRow().getColumnValues(), ConditionFactory.CompareOp.GREATER, includeRow);
                return expression.accept(this);
            }
        }
        return null;
    }

    private void validateRow(Row row) throws IllegalRequestException {
        List<ColumnValue> columnValues = row.getColumnValues();
        if (columnValues.size() <= 0) {
            throw new IllegalRequestException("Found empty columns in row comparison expression, you should add at least one column.");
        }
    }

    private Condition generateSingleCondition(List<ColumnValue> columnValues, ConditionFactory.CompareOp op) throws LindormException {
        if (columnValues.size() == 1) {
            return ConditionFactory.compare(columnValues.get(0), op);
        }
        ConditionList conditionList = ConditionFactory.and();
        for (ColumnValue columnValue : columnValues) {
            conditionList.add(ConditionFactory.compare(columnValue, op));
        }
        return conditionList;
    }

    private Condition generateMultipleConditions(List<ColumnValue> columnValues, ConditionFactory.CompareOp op, boolean includeRow) throws LindormException {
        ConditionFactory.CompareOp lastOp = !includeRow ? op : (op == ConditionFactory.CompareOp.LESS ? ConditionFactory.CompareOp.LESS_OR_EQUAL : ConditionFactory.CompareOp.GREATER_OR_EQUAL);
        int numColumnValues = columnValues.size();
        if (numColumnValues == 1) {
            return ConditionFactory.compare(columnValues.get(0), lastOp);
        }
        ConditionList conditionList = ConditionFactory.or();
        for (int i = 0; i < numColumnValues; ++i) {
            if (i == 0) {
                conditionList.add(ConditionFactory.compare(columnValues.get(i), op));
                continue;
            }
            ConditionList subConditionList = ConditionFactory.and();
            for (int j = 0; j < i; ++j) {
                subConditionList.add(ConditionFactory.compare(columnValues.get(j), ConditionFactory.CompareOp.EQUAL));
            }
            subConditionList.add(ConditionFactory.compare(columnValues.get(i), i != numColumnValues - 1 ? op : lastOp));
            conditionList.add(subConditionList);
        }
        return conditionList;
    }

    @Override
    public DisjunctiveNormalForm visit(ComparisonExpressionV2 node) throws LindormException {
        LColumn column = this.table.resolveColumn(node.getColumnKey());
        if (!node.getCollectionType().equals(column.getDataType())) {
            throw new IllegalRequestException(String.format("type missmatch. column type: %s, provided type: %s", column.getDataType(), node.getCollectionType()));
        }
        Pair<ComparisonExpression, LColumn> pair = node.doSyntaxSugarTransfer(column);
        return new DisjunctiveNormalForm(pair.getSecond(), pair.getFirst());
    }

    @Override
    public DisjunctiveNormalForm visit(InExpression node) throws LindormException {
        List<Object> values = node.getValues();
        if (values == null || values.isEmpty()) {
            throw new IllegalRequestException("Found null or empty values in IN expression, you should add at least one value.");
        }
        ColumnKey columnKey = node.getColumnKey();
        ConditionList or = ConditionFactory.or();
        for (Object value : values) {
            or.add(ConditionFactory.compare(columnKey.getFamily(), columnKey.getQualifier(), ConditionFactory.CompareOp.EQUAL, value));
        }
        return or.accept(this);
    }

    @Override
    public DisjunctiveNormalForm visit(NotInExpression node) throws LindormException {
        List<Object> values = node.getValues();
        if (values == null || values.isEmpty()) {
            throw new IllegalRequestException("Found null or empty values in NOT IN expression, you should add at least one value.");
        }
        ColumnKey columnKey = node.getColumnKey();
        ConditionList and = ConditionFactory.and();
        for (Object value : values) {
            and.add(ConditionFactory.compare(columnKey.getFamily(), columnKey.getQualifier(), ConditionFactory.CompareOp.NOT_EQUAL, value));
        }
        return and.accept(this);
    }

    @Override
    public DisjunctiveNormalForm visit(NotExistExpression node) throws LindormException {
        LColumn column = this.table.resolveColumn(node.getColumnKey());
        if (column.isCollectionType()) {
            throw new LindormException("The type of the column [" + column.getColumnKey() + "] can not be used NOT EXIST condition");
        }
        return new DisjunctiveNormalForm(column, node);
    }

    @Override
    public DisjunctiveNormalForm visit(ExistExpression node) throws LindormException {
        LColumn column = this.table.resolveColumn(node.getColumnKey());
        if (column.isCollectionType()) {
            throw new LindormException("The type of the column [" + column.getColumnKey() + "] can not be used EXIST condition");
        }
        ColumnKey columnKey = node.getColumnKey();
        ConditionList or = ConditionFactory.or(ConditionFactory.compare(columnKey.getFamily(), columnKey.getQualifier(), ConditionFactory.CompareOp.IS_NOT, null), ConditionFactory.compare(columnKey.getFamily(), columnKey.getQualifier(), ConditionFactory.CompareOp.IS, null));
        return or.accept(this);
    }

    @Override
    public DisjunctiveNormalForm visit(LikeExpression node) throws LindormException {
        LColumn column = this.table.resolveColumn(node.getColumnKey());
        DataType type = column.getDataType().getClientType();
        if (!(type.equals((Object)DataType.HSTRING) || type.equals((Object)DataType.STRING) || type.equals((Object)DataType.VARBINARY) || type.equals((Object)DataType.BLOB))) {
            throw new LindormException("The type of the column [" + column.getColumnKey() + "] can not be used LIKE condition");
        }
        return new DisjunctiveNormalForm(column, node);
    }

    @Override
    public DisjunctiveNormalForm visit(NotLikeExpression node) throws LindormException {
        LColumn column = this.table.resolveColumn(node.getColumnKey());
        DataType type = column.getDataType().getClientType();
        if (!(type.equals((Object)DataType.STRING) || type.equals((Object)DataType.VARBINARY) || type.equals((Object)DataType.BLOB))) {
            throw new LindormException("The type of the column [" + column.getColumnKey() + "] can not be used NOT LIKE condition");
        }
        return new DisjunctiveNormalForm(column, node);
    }
}

