/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.core.compile.Interval;
import com.alibaba.lindorm.client.core.compile.KeySlot;
import com.alibaba.lindorm.client.core.compile.PrimaryKeyExpressionVisitor;
import com.alibaba.lindorm.client.core.compile.ScanRanges;
import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WhereCompiler {
    public static final Log LOG = LogFactory.getLog(WhereCompiler.class);
    private final TableMeta table;
    private final Expression where;

    public WhereCompiler(TableMeta table, Expression where) {
        this.table = table;
        this.where = where;
    }

    public WhereCompileResult compile() throws LindormException {
        WhereCompileResult result = new WhereCompileResult();
        if (this.where == null) {
            result.scanRanges = ScanRanges.EVERYTHING;
            return result;
        }
        List<KeySlot> slots = this.parsePrimaryKeyExpression();
        ScannablePKRanges pkRanges = this.pickupScannablePrimaryKey(slots);
        result.pkExpressions = CollectionUtils.newHashSetWithExpectedSize(10);
        for (KeySlot ks : pkRanges.slots) {
            result.pkExpressions.addAll(ks.getExpressions());
        }
        result.scanRanges = this.createScanRanges(pkRanges);
        return result;
    }

    private List<KeySlot> parsePrimaryKeyExpression() throws LindormException {
        PrimaryKeyExpressionVisitor pkExprCompiler = new PrimaryKeyExpressionVisitor(this.table);
        return this.where.accept(pkExprCompiler);
    }

    private ScannablePKRanges pickupScannablePrimaryKey(List<KeySlot> slots) {
        ScannablePKRanges ret = new ScannablePKRanges();
        if (slots == null || slots.isEmpty()) {
            ret.slots = Collections.emptyList();
            return ret;
        }
        ret.slots = CollectionUtils.newArrayListWithCapacity(slots.size());
        ret.hasRangeKey = false;
        int lastPKPosition = -1;
        for (KeySlot ks : slots) {
            if (ks.getPkPosition() != lastPKPosition + 1) break;
            lastPKPosition = ks.getPkPosition();
            ret.slots.add(ks);
            List<Interval> ranges = ks.getIntervals();
            if (ranges.size() > 0) {
                ret.numberOfSingleScanRanges *= ranges.size();
            }
            for (Interval interval : ranges) {
                if (interval.isSingleValue()) continue;
                ret.hasRangeKey = true;
                break;
            }
            if (!ret.hasRangeKey) continue;
            break;
        }
        return ret;
    }

    private ScanRanges createScanRanges(ScannablePKRanges pkRanges) throws LindormException {
        ScanRanges ret;
        List<KeySlot> slots = pkRanges.slots;
        if (slots.isEmpty()) {
            ret = ScanRanges.create(ScanRanges.EVERYTHING);
        } else if (this.isPointLookup(pkRanges)) {
            List<byte[]> rowkeys = this.getPointLookUpKeys(pkRanges);
            ArrayList<Interval> intervals = CollectionUtils.newArrayListWithCapacity(rowkeys.size());
            for (byte[] rowkey : rowkeys) {
                intervals.add(Interval.create(rowkey));
            }
            ret = ScanRanges.create(intervals, true);
        } else {
            List<Interval> minMaxRanges = this.getMinMaxRanges(pkRanges);
            ret = ScanRanges.create(minMaxRanges, false);
        }
        return ret;
    }

    private boolean isPointLookup(ScannablePKRanges pkRanges) {
        if (pkRanges.slots.get(0).isSpan()) {
            return pkRanges.slots.size() == 1;
        }
        if (pkRanges.slots.size() != this.table.getPkColumns().size()) {
            return false;
        }
        return !pkRanges.hasRangeKey;
    }

    private List<byte[]> getPointLookUpKeys(ScannablePKRanges pkRanges) {
        int[] position = new int[pkRanges.slots.size()];
        ArrayList<byte[]> keys = CollectionUtils.newArrayListWithCapacity(pkRanges.numberOfSingleScanRanges);
        do {
            byte[] rowkey = this.generateRowKey(pkRanges.slots, position);
            keys.add(rowkey);
        } while (this.incrementKey(pkRanges.slots, position));
        return keys;
    }

    private List<Interval> getMinMaxRanges(ScannablePKRanges pkRanges) throws LindormException {
        if (pkRanges.slots.get(0).getIntervals().get(0) == Interval.EMPTY_RANGE) {
            return CollectionUtils.newArrayList(Interval.EMPTY_RANGE);
        }
        List<SingleIntervalKeySlot[]> flatSlots = this.flattenKeySlots(pkRanges);
        ArrayList<Interval> scanRanges = CollectionUtils.newArrayListWithCapacity(flatSlots.size());
        for (SingleIntervalKeySlot[] flatSlot : flatSlots) {
            byte[] startKey = CompilerUtils.getMinKey(flatSlot);
            byte[] stopKey = CompilerUtils.getMaxKey(flatSlot);
            scanRanges.add(Interval.create(startKey, stopKey));
        }
        return scanRanges;
    }

    private List<SingleIntervalKeySlot[]> flattenKeySlots(ScannablePKRanges pkRanges) {
        List<KeySlot> slots = pkRanges.slots;
        if (slots == null || slots.isEmpty()) {
            return Collections.emptyList();
        }
        int rangeNum = pkRanges.numberOfSingleScanRanges;
        List<SingleIntervalKeySlot[]> ret = rangeNum == 1 ? this.generateFlatKeySlotForSingleRange(slots) : this.generateFlatKeySlotsForMultipleRanges(slots, rangeNum);
        return ret;
    }

    private List<SingleIntervalKeySlot[]> generateFlatKeySlotForSingleRange(List<KeySlot> slots) {
        ArrayList<SingleIntervalKeySlot[]> ret = CollectionUtils.newArrayListWithCapacity(1);
        SingleIntervalKeySlot[] flatKeys = new SingleIntervalKeySlot[slots.size()];
        for (int i = 0; i < slots.size(); ++i) {
            KeySlot ks = slots.get(i);
            flatKeys[i] = new SingleIntervalKeySlot(ks.getColumn(), ks.getIntervals().get(0));
        }
        ret.add(flatKeys);
        return ret;
    }

    private List<SingleIntervalKeySlot[]> generateFlatKeySlotsForMultipleRanges(List<KeySlot> slots, int rangeNum) {
        ArrayList<SingleIntervalKeySlot[]> ret = CollectionUtils.newArrayListWithCapacity(rangeNum);
        SingleIntervalKeySlot[][] singleIntervalSlots = new SingleIntervalKeySlot[slots.size()][];
        for (int pk = 0; pk < slots.size(); ++pk) {
            KeySlot ks = slots.get(pk);
            List<Interval> intervals = ks.getIntervals();
            SingleIntervalKeySlot[] currSIKS = new SingleIntervalKeySlot[intervals.size()];
            for (int j = 0; j < intervals.size(); ++j) {
                currSIKS[j] = new SingleIntervalKeySlot(ks.getColumn(), intervals.get(j));
            }
            singleIntervalSlots[pk] = currSIKS;
        }
        int[] position = new int[slots.size()];
        do {
            ret.add(this.generatePrefixScanRange(singleIntervalSlots, position));
        } while (this.incrementKey(slots, position));
        return ret;
    }

    private SingleIntervalKeySlot[] generatePrefixScanRange(SingleIntervalKeySlot[][] slots, int[] position) {
        SingleIntervalKeySlot[] flatSlots = new SingleIntervalKeySlot[slots.length];
        for (int i = 0; i < slots.length; ++i) {
            flatSlots[i] = slots[i][position[i]];
        }
        return flatSlots;
    }

    private boolean incrementKey(List<KeySlot> slots, int[] position) {
        int i;
        for (i = slots.size() - 1; i >= 0; --i) {
            position[i] = (position[i] + 1) % slots.get(i).getIntervals().size();
            if (position[i] != 0) break;
        }
        return i >= 0;
    }

    private byte[] generateRowKey(List<KeySlot> slots, int[] position) {
        List<LColumn> pkColumns = this.table.getPkColumns();
        byte[][] values = new byte[pkColumns.size()][];
        int keyLength = 0;
        for (int i = 0; i < slots.size(); ++i) {
            KeySlot ks = slots.get(i);
            Interval itvl = ks.getIntervals().get(position[i]);
            values[ks.getPkPosition()] = itvl.getLower();
            keyLength += values[ks.getPkPosition()].length;
        }
        return CompilerUtils.concatRowKey((byte[][])values, keyLength);
    }

    public static class SingleIntervalKeySlot {
        public LColumn column;
        public Interval interval;

        SingleIntervalKeySlot(LColumn column, Interval interval) {
            this.interval = interval;
            this.column = column;
        }
    }

    private static class ScannablePKRanges {
        List<KeySlot> slots;
        boolean hasRangeKey = false;
        int numberOfSingleScanRanges = 0;

        private ScannablePKRanges() {
        }
    }

    public static class WhereCompileResult {
        public Set<Expression> pkExpressions = null;
        public ScanRanges scanRanges = null;
    }
}

