/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.expression.ExpressionType;
import com.alibaba.lindorm.client.core.expression.ExpressionVisitor;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.Tuple;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.ImmutableBytesPtr;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.ConditionFactory;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ComparisonExpressionV3
extends Condition {
    protected ConditionFactory.CompareOp op;
    protected Expression left;
    protected Expression right;

    public ComparisonExpressionV3() {
    }

    public ComparisonExpressionV3(ConditionFactory.CompareOp op, Expression left, Expression right) {
        this.op = op;
        this.left = left;
        this.right = right;
    }

    public ConditionFactory.CompareOp getOp() {
        return this.op;
    }

    public void setOp(ConditionFactory.CompareOp op) {
        this.op = op;
    }

    public Expression getLeft() {
        return this.left;
    }

    public void setLeft(Expression left) {
        this.left = left;
    }

    public Expression getRight() {
        return this.right;
    }

    public void setRight(Expression right) {
        this.right = right;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesPtr result) throws LindormException {
        Pair<Boolean, Object> pair1 = this.left.evaluate(tuple);
        if (!pair1.getFirst().booleanValue()) {
            return false;
        }
        Pair<Boolean, Object> pair2 = this.right.evaluate(tuple);
        if (!pair2.getFirst().booleanValue()) {
            return false;
        }
        int c = this.left.getComparator().compare(pair1.getSecond(), pair2.getSecond());
        boolean ret = CompilerUtils.compare(this.op, c, pair1.getSecond() == null);
        result.set(ret ? DataTypeUtils.TRUE_BYTES : DataTypeUtils.FALSE_BYTES);
        return true;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) throws LindormException {
        return visitor.visit(this);
    }

    @Override
    public void reset() {
        this.left.reset();
        this.right.reset();
    }

    @Override
    public void resetParamValues(List<Object> params) throws LindormException {
        this.left.resetParamValues(params);
        this.right.resetParamValues(params);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComparisonExpressionV3 that = (ComparisonExpressionV3)o;
        if (this.op != that.op) {
            return false;
        }
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        return this.right != null ? this.right.equals(that.right) : that.right == null;
    }

    public int hashCode() {
        int result = this.op != null ? this.op.hashCode() : 0;
        result = 31 * result + (this.left != null ? this.left.hashCode() : 0);
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return String.format("%s %s %s", this.left, this.op.getStr(), this.right);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeVInt(out, this.op.ordinal());
        WritableUtils.writeVInt(out, ExpressionType.getOrdinal(this.left));
        WritableUtils.writeVInt(out, ExpressionType.getOrdinal(this.right));
        this.left.writeTo(out);
        this.right.writeTo(out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.op = ConditionFactory.CompareOp.values()[WritableUtils.readVInt(in)];
        this.left = ExpressionType.fromOrdinal(WritableUtils.readVInt(in));
        this.right = ExpressionType.fromOrdinal(WritableUtils.readVInt(in));
        this.left.readFrom(in);
        this.right.readFrom(in);
    }

    @Override
    public Set<LColumn> usedColumns() {
        HashSet<LColumn> ret = new HashSet<LColumn>();
        ret.addAll(this.left.usedColumns());
        ret.addAll(this.right.usedColumns());
        return ret;
    }
}

