/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.Literal;
import com.alibaba.lindorm.client.core.types.LDecimal;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;

public class DecimalLiteral
extends Literal {
    private BigDecimal value;

    public DecimalLiteral() {
        super(LDecimal.INSTANCE);
    }

    public DecimalLiteral(BigDecimal value) {
        super(LDecimal.INSTANCE);
        this.value = value;
    }

    public DecimalLiteral setValue(BigDecimal value) {
        this.value = value;
        return this;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        out.writeUTF(this.value.toString());
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.value = new BigDecimal(in.readUTF());
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }
}

