/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.expression.ExpressionType;
import com.alibaba.lindorm.client.core.expression.ExpressionVisitor;
import com.alibaba.lindorm.client.core.expression.Identifier;
import com.alibaba.lindorm.client.core.expression.Literal;
import com.alibaba.lindorm.client.core.function.Function;
import com.alibaba.lindorm.client.core.function.FunctionCenter;
import com.alibaba.lindorm.client.core.function.FunctionName;
import com.alibaba.lindorm.client.core.meta.ColumnValueTuple;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.Tuple;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.ImmutableBytesPtr;
import com.alibaba.lindorm.client.core.utils.LindormObjectUtils;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.core.utils.Preconditions;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FunctionCall
extends Expression {
    private static final String ALIAS_ATTR = "alias_attr";
    protected String name;
    protected List<Expression> arguments = new ArrayList<Expression>();
    protected boolean compiled;
    private String alias;
    protected boolean isResultCached = false;
    protected Object evaluateResultCache = null;
    private Function function;
    private List<LDataType> argTypes;

    public FunctionCall() {
    }

    public FunctionCall(String name, Expression ... arguments) {
        this(name, (String)null, arguments);
    }

    public FunctionCall(String name, String alias, Expression ... arguments) {
        this.name = name;
        this.alias = alias;
        Collections.addAll(this.arguments, arguments);
        this.compiled = false;
    }

    public String getName() {
        return this.name;
    }

    public FunctionCall setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isCompiled() {
        return this.compiled;
    }

    public void setCompiled(boolean compiled) {
        this.compiled = compiled;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    public FunctionCall setArguments(List<Expression> arguments) {
        this.arguments = arguments;
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public FunctionCall setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public byte[] getBytes() {
        try {
            return LindormObjectUtils.getBytes(this);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void fromBytes(byte[] bytes, int offset, int length) {
        try {
            LindormObjectUtils.getWritable(bytes, offset, length, this);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void fromBytes(byte[] bytes) {
        try {
            LindormObjectUtils.getWritable(bytes, this);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setupAttributes();
        super.writeTo(out);
        WritableUtils.writeString(out, this.name);
        out.writeBoolean(this.compiled);
        out.writeInt(this.arguments.size());
        for (Expression expr : this.arguments) {
            WritableUtils.writeVInt(out, ExpressionType.getOrdinal(expr));
            expr.writeTo(out);
        }
    }

    private void setupAttributes() {
        if (this.alias != null) {
            this.setAttribute(ALIAS_ATTR, Bytes.toBytes(this.alias));
        } else {
            this.removeAttribute(ALIAS_ATTR);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.name = WritableUtils.readString(in);
        this.compiled = in.readBoolean();
        int size = in.readInt();
        this.arguments = new ArrayList<Expression>(size);
        for (int i = 0; i < size; ++i) {
            Expression expr = ExpressionType.fromOrdinal(WritableUtils.readVInt(in));
            expr.readFrom(in);
            this.arguments.add(expr);
        }
        this.readFromAttribute();
    }

    private void readFromAttribute() {
        byte[] aliasBytes = this.getAttribute(ALIAS_ATTR);
        if (aliasBytes != null) {
            this.alias = Bytes.toString(aliasBytes);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FunctionCall that = (FunctionCall)o;
        if (this.compiled != that.compiled) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.arguments != null ? this.arguments.equals(that.arguments) : that.arguments == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        result = 31 * result + (this.compiled ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(this.name);
        builder.append("(");
        ArrayList<String> list = new ArrayList<String>();
        for (Expression expr : this.arguments) {
            list.add(expr.toString());
        }
        builder.append(StringUtils.join(", ", list));
        builder.append(")");
        return builder.toString();
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) throws LindormException {
        return visitor.visit(this);
    }

    @Override
    public void reset() {
        for (Expression expr : this.arguments) {
            expr.reset();
        }
    }

    @Override
    public void resetParamValues(List<Object> params) throws LindormException {
        for (Expression expr : this.arguments) {
            expr.resetParamValues(params);
        }
    }

    @Override
    public Set<LColumn> usedColumns() {
        HashSet<LColumn> ret = new HashSet<LColumn>();
        for (Expression expr : this.arguments) {
            ret.addAll(expr.usedColumns());
        }
        return ret;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesPtr result) throws LindormException {
        Pair<Boolean, Object> pair = this.evaluate(tuple);
        if (pair.getFirst().booleanValue()) {
            Boolean ret = pair.getSecond() != null && (Boolean)pair.getSecond() != false;
            result.set(ret != false ? DataTypeUtils.TRUE_BYTES : DataTypeUtils.FALSE_BYTES);
            return true;
        }
        return false;
    }

    public Function getFunction() {
        Preconditions.checkArgument(this.compiled, "should not invoke in client side");
        if (this.function == null) {
            this.function = FunctionCenter.getResolver().get(FunctionName.parse(this.name), this.getArgTypes());
        }
        return this.function;
    }

    private List<LDataType> getArgTypes() {
        if (this.argTypes == null) {
            this.castTypesIfNeccessary();
            this.argTypes = new ArrayList<LDataType>();
            for (Expression expr : this.arguments) {
                this.argTypes.add(expr.getLDataType());
            }
        }
        return this.argTypes;
    }

    public void castTypesIfNeccessary() {
        if (this.isFunctionArgTypesNeedCastToVarbinary()) {
            for (Expression exp : this.arguments) {
                if (!(exp instanceof Identifier)) continue;
                ((Identifier)exp).castDataTypeToVarbinary(true);
            }
        }
    }

    private boolean isFunctionArgTypesNeedCastToVarbinary() {
        return this.name.equals("hash32") || this.name.equals("hash64");
    }

    @Override
    public Class getValueClass() {
        Preconditions.checkNotNull(this.getFunction());
        return this.function.returnType().getJavaClass();
    }

    @Override
    public LDataType getLDataType() {
        Preconditions.checkNotNull(this.getFunction());
        return this.function.returnType();
    }

    @Override
    public Comparator getComparator() {
        Preconditions.checkNotNull(this.getFunction());
        return this.function.getComparator();
    }

    @Override
    public Pair<Boolean, Object> evaluate(Tuple tuple) throws LindormException {
        Preconditions.checkNotNull(this.getFunction());
        if (this.isResultCached) {
            return Pair.newPair(true, this.evaluateResultCache);
        }
        ArrayList<Object> argsHolder = new ArrayList<Object>();
        boolean allArgumentsLiteral = true;
        for (Expression expr : this.arguments) {
            Pair<Boolean, Object> pair;
            if (!(expr instanceof Literal)) {
                allArgumentsLiteral = false;
            }
            if ((pair = expr.evaluate(tuple)).getFirst().booleanValue()) {
                argsHolder.add(pair.getSecond());
                continue;
            }
            return Pair.newPair(false, null);
        }
        Object result = this.function.evaluate(argsHolder);
        if (allArgumentsLiteral && !this.isResultCached) {
            this.evaluateResultCache = result;
            this.isResultCached = true;
        }
        return Pair.newPair(true, result);
    }

    @Override
    public Pair<Boolean, Object> evaluate(ColumnValueTuple tuple) throws LindormException {
        Preconditions.checkNotNull(this.getFunction());
        ArrayList<Object> argsHolder = new ArrayList<Object>();
        for (Expression expr : this.arguments) {
            Pair<Boolean, Object> pair = expr.evaluate(tuple);
            if (pair.getFirst().booleanValue()) {
                argsHolder.add(pair.getSecond());
                continue;
            }
            return Pair.newPair(false, null);
        }
        return Pair.newPair(true, this.function.evaluate(argsHolder));
    }
}

