/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.expression.ExpressionVisitor;
import com.alibaba.lindorm.client.core.meta.ColumnValueTuple;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.Tuple;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LVarbinary;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.ImmutableBytesPtr;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.core.utils.Preconditions;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class Identifier
extends Expression {
    private static final String CAST_TO_VARBINARY = "CAST_TO_VARBINARY";
    private String value;
    private LColumn column;
    private boolean castToVarbinary = false;
    private ColumnKey columnKey = null;

    public Identifier() {
    }

    public Identifier(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public ColumnKey toColumnKey() {
        if (this.columnKey == null) {
            String[] splits = this.value.split(SchemaUtils.COLUMN_NAME_SEPARATOR);
            this.columnKey = splits.length == 2 ? new ColumnKey(splits[0], splits[1]) : new ColumnKey(splits[0]);
        }
        return this.columnKey;
    }

    public Identifier setValue(String value) {
        this.value = value;
        this.columnKey = null;
        return this;
    }

    public Identifier setColumn(LColumn column) {
        this.column = column;
        return this;
    }

    public Identifier castDataTypeToVarbinary(boolean castToVarbinary) {
        this.castToVarbinary = castToVarbinary;
        return this;
    }

    public boolean getCastToVarbinary() {
        return this.castToVarbinary;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setupAttributes();
        super.writeTo(out);
        WritableUtils.writeString(out, this.value);
        if (this.column != null) {
            out.writeBoolean(true);
            this.column.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    private void setupAttributes() {
        if (this.castToVarbinary) {
            this.setAttribute(CAST_TO_VARBINARY, Bytes.toBytes(this.castToVarbinary));
        } else {
            this.removeAttribute(CAST_TO_VARBINARY);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.value = WritableUtils.readString(in);
        if (in.readBoolean()) {
            this.column = new LColumn();
            this.column.readFrom(in);
        }
        this.initFromAttributes();
    }

    private void initFromAttributes() throws IllegalDataException {
        byte[] dataTypeBytes = this.getAttribute(CAST_TO_VARBINARY);
        if (dataTypeBytes != null) {
            this.castToVarbinary = Bytes.toBoolean(dataTypeBytes);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Identifier that = (Identifier)o;
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesPtr result) throws LindormException {
        Pair<Boolean, Object> pair = this.evaluate(tuple);
        if (pair.getFirst().booleanValue()) {
            Boolean b = (Boolean)pair.getSecond();
            result.set(b == null || b == false ? DataTypeUtils.FALSE_BYTES : DataTypeUtils.TRUE_BYTES);
            return true;
        }
        return false;
    }

    @Override
    public Class getValueClass() {
        if (this.castToVarbinary) {
            return LVarbinary.INSTANCE.getJavaClass();
        }
        Preconditions.checkNotNull(this.column);
        return this.column.getDataType().getJavaClass();
    }

    @Override
    public LDataType getLDataType() {
        if (this.castToVarbinary) {
            return LVarbinary.INSTANCE;
        }
        Preconditions.checkNotNull(this.column);
        return this.column.getDataType();
    }

    @Override
    public Comparator getComparator() {
        Preconditions.checkNotNull(this.column);
        return this.column.getDataType().getComparator();
    }

    @Override
    public Pair<Boolean, Object> evaluate(Tuple tuple) throws LindormException {
        Preconditions.checkNotNull(this.column);
        ImmutableBytesPtr ptr = new ImmutableBytesPtr();
        if (this.column.isPrimaryKey()) {
            tuple.getPrimaryKeys().getPKValue(this.column.getPosition(), ptr);
            if (SchemaUtils.storePkNulls(this.column) && (ptr.getLength() == 0 || SchemaUtils.isNullValueByte(ptr.get()[ptr.getOffset()], this.column.getSortOrder()))) {
                return Pair.newPair(true, null);
            }
        } else {
            tuple.getKeyValue(this.column.getFamilyName(), this.column.getColumnName(), ptr);
            if (ptr.get() == Bytes.EMPTY_BYTE_ARRAY) {
                return Pair.newPair(false, null);
            }
        }
        if (this.castToVarbinary) {
            return Pair.newPair(true, ptr.copyBytes());
        }
        Object val = LDataType.toObject(this.column, ptr.get(), ptr.getOffset(), ptr.getLength());
        return Pair.newPair(true, val);
    }

    @Override
    public Pair<Boolean, Object> evaluate(ColumnValueTuple tuple) throws LindormException {
        Preconditions.checkNotNull(this.column);
        byte[] val = null;
        if (this.column.isPrimaryKey()) {
            val = tuple.getPkValueBytes(this.column);
        } else {
            val = tuple.getNonPkValueBytes(this.column);
            if (val == null) {
                return Pair.newPair(false, null);
            }
        }
        if (this.castToVarbinary) {
            return Pair.newPair(true, val);
        }
        Object valObject = LDataType.toObject(this.column, val);
        return Pair.newPair(true, valObject);
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) throws LindormException {
        return visitor.visit(this);
    }

    @Override
    public void reset() {
    }

    @Override
    public void resetParamValues(List<Object> params) throws LindormException {
    }

    public LColumn getColumn() {
        return this.column;
    }

    @Override
    public Set<LColumn> usedColumns() {
        Preconditions.checkNotNull(this.column);
        return Collections.singleton(this.column);
    }
}

