/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.ExpressionVisitor;
import com.alibaba.lindorm.client.core.expression.MultipleValuesExpression;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.Arrays;
import java.util.List;

public class InExpression
extends MultipleValuesExpression {
    public InExpression() {
    }

    public InExpression(byte[] columnName, Object ... values) throws LindormException {
        super(columnName, Arrays.asList(values));
    }

    public InExpression(byte[] familyName, byte[] columnName, Object ... values) throws LindormException {
        super(familyName, columnName, Arrays.asList(values));
    }

    public InExpression(byte[] columnName, List<?> values) throws LindormException {
        super(columnName, values);
    }

    public InExpression(byte[] familyName, byte[] columnName, List<?> values) throws LindormException {
        super(familyName, columnName, values);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(this.columnKey.getQualifierAsString());
        builder.append(" in (");
        for (int i = 0; i < this.values.size(); ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(DataTypeUtils.valueToString(this.type, this.values.get(i)));
        }
        builder.append(")");
        builder.append(")");
        return builder.toString();
    }

    @Override
    public String toParseableString() {
        return this.toString();
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) throws LindormException {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InExpression)) {
            return false;
        }
        InExpression other = (InExpression)obj;
        if (!this.columnKey.equals(other.columnKey)) {
            return false;
        }
        if (!this.type.equals((Object)other.type)) {
            return false;
        }
        if (this.values.size() != other.values.size()) {
            return false;
        }
        if (this.values.get(0) instanceof byte[]) {
            for (int i = 0; i < this.values.size(); ++i) {
                if (Bytes.equals((byte[])this.values.get(i), (byte[])other.values.get(i))) continue;
                return false;
            }
            return true;
        }
        return this.values.equals(other.values);
    }
}

