/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.expression.ExpressionVisitor;
import com.alibaba.lindorm.client.core.meta.ColumnValueTuple;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.Tuple;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.utils.ImmutableBytesPtr;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public abstract class Literal
extends Expression {
    protected LDataType type;

    public Literal(LDataType type) {
        this.type = type;
    }

    @Override
    public Class getValueClass() {
        return this.type.getJavaClass();
    }

    @Override
    public LDataType getLDataType() {
        return this.type;
    }

    public abstract Object getValue();

    @Override
    public Comparator getComparator() {
        return this.type.getComparator();
    }

    @Override
    public Pair<Boolean, Object> evaluate(Tuple tuple) throws LindormException {
        return Pair.newPair(true, this.getValue());
    }

    @Override
    public Pair<Boolean, Object> evaluate(ColumnValueTuple tuple) throws LindormException {
        return Pair.newPair(true, this.getValue());
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesPtr result) throws LindormException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) throws LindormException {
        return visitor.visit(this);
    }

    @Override
    public void reset() {
    }

    @Override
    public void resetParamValues(List<Object> params) throws LindormException {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Literal that = (Literal)o;
        return this.getValue() != null ? this.getValue().equals(that.getValue()) : that.getValue() == null;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getValue());
    }

    public int hashCode() {
        return this.getValue() != null ? this.getValue().hashCode() : 0;
    }

    @Override
    public Set<LColumn> usedColumns() {
        return Collections.emptySet();
    }
}

