/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.Literal;
import com.alibaba.lindorm.client.core.types.LVarbinary;
import com.alibaba.lindorm.client.core.utils.Bytes;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class VarbinaryLiteral
extends Literal {
    private byte[] value;

    public VarbinaryLiteral() {
        super(LVarbinary.INSTANCE);
    }

    public VarbinaryLiteral(byte[] value) {
        super(LVarbinary.INSTANCE);
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    public VarbinaryLiteral setValue(byte[] value) {
        this.value = value;
        return this;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Bytes.writeByteArray(out, this.value);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.value = Bytes.readByteArray(in);
    }

    @Override
    public String toString() {
        return Bytes.toStringBinary(this.value);
    }
}

