/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.feedstreamservice;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FeedStreamAttributes
extends VersionedObjectWithAttributes {
    List<Long> prevMessageIds;

    public FeedStreamAttributes() {
        this.prevMessageIds = new ArrayList<Long>();
    }

    public FeedStreamAttributes(List<Long> prevSeqIds) {
        this.prevMessageIds = prevSeqIds;
    }

    public List<Long> getPrevMessageIds() {
        return this.prevMessageIds;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeVInt(out, this.prevMessageIds.size());
        for (Long messageId : this.prevMessageIds) {
            WritableUtils.writeVLong(out, messageId);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FeedStreamAttributes that = (FeedStreamAttributes)o;
        return this.prevMessageIds != null ? this.prevMessageIds.equals(that.prevMessageIds) : that.prevMessageIds == null;
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        int size = WritableUtils.readVInt(in);
        this.prevMessageIds = new ArrayList<Long>(size);
        for (int i = 0; i < size; ++i) {
            this.prevMessageIds.add(WritableUtils.readVLong(in));
        }
    }
}

