/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.feedstreamservice;

import com.alibaba.lindorm.client.core.compile.RowVisitor;
import com.alibaba.lindorm.client.core.feedstreamservice.LMessage;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.FeedStreamUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.ColumnValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StreamRowToMessageVisitor
extends RowVisitor<LMessage, Object> {
    private static final Map<ColumnKey, RowVisitor.ColumnValueVisitor<LMessage, Object>> VISITOR_MAP;
    private static final RowVisitor.ColumnValueVisitor<LMessage, Object> DEFAULT_VISITOR;

    public StreamRowToMessageVisitor() {
        super(DEFAULT_VISITOR, VISITOR_MAP);
    }

    @Override
    protected LMessage createResult(Object context) {
        return new LMessage();
    }

    static {
        HashMap<ColumnKey, RowVisitor.ColumnValueVisitor<LMessage, Object>> tmp = CollectionUtils.newHashMapWithExpectedSize(5);
        tmp.put(FeedStreamUtils.CKV_HASH, new RowVisitor.ColumnValueVisitor<LMessage, Object>(){

            @Override
            public void handleColumnValue(ColumnValue cv, LMessage result, Object context) {
            }
        });
        tmp.put(FeedStreamUtils.CKV_STREAM_NAME, new RowVisitor.ColumnValueVisitor<LMessage, Object>(){

            @Override
            public void handleColumnValue(ColumnValue cv, LMessage result, Object context) {
                result.setStreamName(cv.getString());
            }
        });
        tmp.put(FeedStreamUtils.CKV_MESSAGE_ID, new RowVisitor.ColumnValueVisitor<LMessage, Object>(){

            @Override
            public void handleColumnValue(ColumnValue cv, LMessage result, Object context) {
                result.setMessageId(cv.getLong());
            }
        });
        tmp.put(FeedStreamUtils.CKV_IDEMPOTENT_ID, new RowVisitor.ColumnValueVisitor<LMessage, Object>(){

            @Override
            public void handleColumnValue(ColumnValue cv, LMessage result, Object context) {
                result.setIdempotentId(cv.getBinary());
            }
        });
        tmp.put(FeedStreamUtils.CKV_BODY, new RowVisitor.ColumnValueVisitor<LMessage, Object>(){

            @Override
            public void handleColumnValue(ColumnValue cv, LMessage result, Object context) {
                result.setMessageBody(cv.getBinary());
                if (cv.getTags() != null) {
                    result.setBodyTags(cv.getTags());
                }
            }
        });
        VISITOR_MAP = Collections.unmodifiableMap(tmp);
        DEFAULT_VISITOR = new RowVisitor.ColumnValueVisitor<LMessage, Object>(){

            @Override
            public void handleColumnValue(ColumnValue cv, LMessage result, Object context) {
                result.addTag(cv.getColumnNameAsString(), cv.getBinary());
                if (cv.getTags() != null) {
                    result.addTagTags(cv.getColumnNameAsString(), cv.getTags());
                }
            }
        };
    }
}

